/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.mouse;

import java.awt.event.MouseEvent;
import java.io.Serializable;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.action.CloseWithAbortWindowAction;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.gui.mouse.MouseButtonListener;

public class DockingWindowActionMouseButtonListener
implements MouseButtonListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MODIFIER_MASK = 960;
    public static final MouseButtonListener MIDDLE_BUTTON_CLOSE_LISTENER = new DockingWindowActionMouseButtonListener(2, CloseWithAbortWindowAction.INSTANCE);
    private int eventId;
    private int button;
    private int keyMask;
    private DockingWindowAction action;
    private boolean consumeEvent;

    public DockingWindowActionMouseButtonListener(int button, DockingWindowAction action) {
        this(500, button, action);
    }

    public DockingWindowActionMouseButtonListener(int eventId, int button, DockingWindowAction action) {
        this(eventId, button, 0, action, false);
    }

    public DockingWindowActionMouseButtonListener(int eventId, int button, int keyMask, DockingWindowAction action, boolean consumeEvent) {
        this.eventId = eventId;
        this.button = button;
        this.keyMask = keyMask;
        this.action = action;
        this.consumeEvent = consumeEvent;
    }

    @Override
    public void mouseButtonEvent(MouseEvent event) {
        if (event.isConsumed()) {
            return;
        }
        int m = event.getModifiersEx() & 0x3C0;
        if (event.getButton() == 2) {
            m &= 0xFFFFFDFF;
        }
        if (event.getButton() == 3) {
            m &= 0xFFFFFEFF;
        }
        if (event.getID() == this.eventId && event.getButton() == this.button && m == this.keyMask) {
            DockingWindow window = (DockingWindow)event.getSource();
            this.action.perform(window);
            if (this.consumeEvent) {
                event.consume();
            }
        }
    }
}

