/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.icon.button;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import net.infonode.gui.icon.button.AbstractButtonIcon;
import net.infonode.util.Direction;

public class ArrowIcon
extends AbstractButtonIcon {
    private Direction direction;

    public ArrowIcon(Direction direction) {
        this.direction = direction;
    }

    public ArrowIcon(Color color, Direction direction) {
        super(color);
        this.direction = direction;
    }

    public ArrowIcon(Color color, int size, Direction direction) {
        super(color, size);
        this.direction = direction;
    }

    public ArrowIcon(int size, Direction direction) {
        this(size, direction, true);
    }

    public ArrowIcon(int size, Direction direction, boolean enabled) {
        super(size, enabled);
        this.direction = direction;
    }

    public Direction getDirection() {
        return this.direction;
    }

    @Override
    protected void paintIcon(Component c, Graphics g, int x1, int y1, int x2, int y2) {
        int[] nArray;
        int o2;
        int size = x2 - x1 + 1 + (x2 - x1 + 1) % 2 - 1;
        int offset = (this.direction.isHorizontal() ? x1 : y1) + (this.direction == Direction.RIGHT || this.direction == Direction.DOWN ? (size + 1) / 4 : (size - (size + 1) / 2) / 2);
        int n = o2 = this.direction.isHorizontal() ? y1 : x1;
        if (this.direction == Direction.DOWN || this.direction == Direction.RIGHT) {
            int[] nArray2 = new int[3];
            nArray2[0] = offset;
            nArray2[1] = offset;
            nArray = nArray2;
            nArray2[2] = offset + size / 2 + 1;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = offset + size / 2 + 1;
            nArray3[1] = offset + size / 2 + 1;
            nArray = nArray3;
            nArray3[2] = offset - (this.direction == Direction.UP ? 1 : 0);
        }
        int[] c1 = nArray;
        int[] c2 = new int[]{o2 + (this.direction == Direction.DOWN ? 0 : -1), o2 + size + (this.direction == Direction.UP ? 1 : 0), o2 + size / 2};
        g.fillPolygon(this.direction.isHorizontal() ? c1 : c2, this.direction.isHorizontal() ? c2 : c1, 3);
    }
}

