/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.util;

import net.infonode.properties.base.Property;
import net.infonode.properties.base.PropertyGroup;
import net.infonode.properties.base.exception.InvalidPropertyValueException;

public abstract class AbstractProperty
implements Property {
    private PropertyGroup group;
    private String name;
    private Class type;
    private String description;

    protected AbstractProperty(PropertyGroup group, String name, Class type, String description) {
        this.group = group;
        this.name = name;
        this.type = type;
        this.description = description;
        if (group != null) {
            group.addProperty(this);
        }
    }

    @Override
    public PropertyGroup getGroup() {
        return this.group;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public void setValue(Object object, Object value) {
        if (!this.canBeAssiged(value)) {
            throw new InvalidPropertyValueException((Property)this, value);
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean canBeAssiged(Object value) {
        return this.isMutable() && (value == null || this.getType().isAssignableFrom(value.getClass()));
    }
}

