/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util.collection.map;

import java.util.ArrayList;
import net.infonode.util.collection.map.EmptyIterator;
import net.infonode.util.collection.map.base.ConstMap;
import net.infonode.util.collection.map.base.ConstMapIterator;

public class ConstVectorMap
implements ConstMap {
    private ArrayList maps = new ArrayList(2);

    private Object getValue(Object key, int fromIndex, int toIndex) {
        int i = fromIndex;
        while (i < toIndex) {
            Object value = this.getMap(i).get(key);
            if (value != null) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public void addMap(ConstMap map) {
        this.addMap(this.maps.size(), map);
    }

    public void addMap(int index, ConstMap map) {
        this.maps.add(index, map);
    }

    public int getMapCount() {
        return this.maps.size();
    }

    public ConstMap removeMap(int index) {
        return (ConstMap)this.maps.remove(index);
    }

    @Override
    public Object get(Object key) {
        int i = 0;
        while (i < this.maps.size()) {
            Object v = this.getMap(i).get(key);
            if (v != null) {
                return v;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        int i = 0;
        while (i < this.maps.size()) {
            if (this.getMap(i).containsKey(key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        int i = 0;
        while (i < this.maps.size()) {
            if (this.getMap(i).containsValue(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        int i = 0;
        while (i < this.maps.size()) {
            if (!this.getMap(i).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ConstMap getMap(int index) {
        return (ConstMap)this.maps.get(index);
    }

    public int getMapIndex(ConstMap map) {
        return this.maps.indexOf(map);
    }

    @Override
    public ConstMapIterator constIterator() {
        return new ConstIterator();
    }

    private class ConstIterator
    implements ConstMapIterator {
        private int index = 1;
        private ConstMapIterator iterator;

        ConstIterator() {
            if (ConstVectorMap.this.maps.size() > 0) {
                this.iterator = ConstVectorMap.this.getMap(0).constIterator();
                this.advance();
            } else {
                this.iterator = EmptyIterator.INSTANCE;
            }
        }

        @Override
        public Object getKey() {
            return this.iterator.getKey();
        }

        @Override
        public Object getValue() {
            return this.iterator.getValue();
        }

        @Override
        public void next() {
            this.iterator.next();
            this.advance();
        }

        @Override
        public boolean atEntry() {
            return this.iterator.atEntry();
        }

        private void advance() {
            while (true) {
                if (!this.iterator.atEntry()) {
                    if (this.index == ConstVectorMap.this.maps.size()) {
                        return;
                    }
                    this.iterator = ConstVectorMap.this.getMap(this.index++).constIterator();
                    continue;
                }
                if (ConstVectorMap.this.getValue(this.iterator.getKey(), 0, this.index - 1) == null) {
                    return;
                }
                this.iterator.next();
            }
        }
    }
}

