/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute.mindmapmode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.SortedComboBoxModel;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.AttributeRegistryElement;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewManager;

class ImportAttributesDialog
extends JDialog
implements TreeSelectionListener {
    private static final IconStore STORE = IconStoreFactory.ICON_STORE;
    private static final long serialVersionUID = 1L;
    private AttributeRegistry currentAttributes;
    private final Component parentComponent;
    MyRenderer renderer = null;
    private final JScrollPane scrollPane;
    private final DefaultMutableTreeNode topNode;
    private final JTree tree;
    private final DefaultTreeModel treeModel;

    public ImportAttributesDialog(Component parentComponent) {
        super(UITools.getCurrentFrame(), TextUtils.getText((String)"attributes_import"), true);
        this.parentComponent = parentComponent;
        TreeNodeInfo nodeInfo = new TreeNodeInfo(TextUtils.getText((String)"attribute_top"));
        this.topNode = new DefaultMutableTreeNode(nodeInfo);
        this.treeModel = new DefaultTreeModel(this.topNode);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.scrollPane = new JScrollPane();
        UITools.setScrollbarIncrement((JScrollPane)this.scrollPane);
        this.scrollPane.setViewportView(this.tree);
        this.scrollPane.setPreferredSize(new Dimension(600, 300));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        Box buttons = Box.createHorizontalBox();
        buttons.setBorder(new EmptyBorder(5, 5, 5, 5));
        JButton okBtn = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)okBtn, (String)TextUtils.getRawText((String)"ok"));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportAttributesDialog.this.performImport(ImportAttributesDialog.this.topNode);
                ImportAttributesDialog.this.dispose();
            }
        });
        JButton cancelBtn = new JButton();
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)cancelBtn, (String)TextUtils.getRawText((String)"cancel"));
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportAttributesDialog.this.dispose();
            }
        });
        buttons.add(Box.createHorizontalGlue());
        buttons.add(okBtn);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(cancelBtn);
        buttons.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)buttons, "South");
        UITools.addEscapeActionToDialog((JDialog)this);
    }

    private void createAttributeSubTrees(DefaultMutableTreeNode mapInfo, AttributeRegistry attributes) {
        if (attributes == null) {
            return;
        }
        for (int i = 0; i < attributes.size(); ++i) {
            AttributeRegistryElement element = attributes.getElement(i);
            AttributeTreeNodeInfo treeNodeInfo = new AttributeTreeNodeInfo(element.getKey().toString(), element.isRestricted());
            DefaultMutableTreeNode attributeInfo = new DefaultMutableTreeNode(treeNodeInfo);
            this.createValueSubTrees(attributeInfo, element, this.currentAttributes);
            if (attributeInfo.getChildCount() == 0) continue;
            mapInfo.add(attributeInfo);
        }
    }

    private void createMapSubTrees(DefaultMutableTreeNode top) {
        top.removeAllChildren();
        TreeNodeInfo topInfo = (TreeNodeInfo)top.getUserObject();
        topInfo.setSelected(2);
        Controller controller = Controller.getCurrentController();
        IMapViewManager mapViewManager = controller.getMapViewManager();
        MapModel currentMap = controller.getMap();
        this.currentAttributes = AttributeRegistry.getRegistry((MapModel)currentMap);
        for (Map.Entry entry : mapViewManager.getMaps().entrySet()) {
            String nextmapName = (String)entry.getKey();
            MapModel nextMap = (MapModel)entry.getValue();
            if (nextMap == currentMap) continue;
            TreeNodeInfo treeNodeInfo = new TreeNodeInfo(nextmapName);
            DefaultMutableTreeNode mapInfo = new DefaultMutableTreeNode(treeNodeInfo);
            this.createAttributeSubTrees(mapInfo, AttributeRegistry.getRegistry((MapModel)nextMap));
            if (mapInfo.getChildCount() == 0) continue;
            top.add(mapInfo);
        }
    }

    private void createValueSubTrees(DefaultMutableTreeNode attributeInfo, AttributeRegistryElement element, AttributeRegistry currentAttributes) {
        String attributeName = element.getKey().toString();
        SortedComboBoxModel values = element.getValues();
        for (int i = 0; i < values.getSize(); ++i) {
            Object nextElement = values.getElementAt(i);
            if (currentAttributes.exist(attributeName, nextElement)) continue;
            TreeNodeInfo treeNodeInfo = new TreeNodeInfo(nextElement.toString());
            DefaultMutableTreeNode valueInfo = new DefaultMutableTreeNode(treeNodeInfo);
            attributeInfo.add(valueInfo);
        }
    }

    private void performImport(DefaultMutableTreeNode node) {
        TreeNodeInfo info = (TreeNodeInfo)node.getUserObject();
        if (info.getSelected() == 2) {
            return;
        }
        String name = info.getInfo();
        boolean attributeNameRegistered = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            if (childNode.isLeaf()) {
                TreeNodeInfo childInfo;
                if (!attributeNameRegistered) {
                    attributeNameRegistered = true;
                    if (-1 == this.currentAttributes.indexOf(name)) {
                        this.currentAttributes.performRegistryAttribute(name);
                        int index = this.currentAttributes.indexOf(name);
                        this.currentAttributes.performSetRestriction(index, ((AttributeTreeNodeInfo)info).isRestricted());
                    }
                }
                if ((childInfo = (TreeNodeInfo)childNode.getUserObject()).getSelected() != 0) continue;
                String value = childInfo.getInfo();
                this.currentAttributes.performRegistryAttributeValue(name, value, true);
                continue;
            }
            this.performImport(childNode);
        }
    }

    private void setParentSelectionType(DefaultMutableTreeNode selectedNode, int newSelectionType) {
        TreeNode parentNode = selectedNode.getParent();
        if (parentNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableParentNode = (DefaultMutableTreeNode)parentNode;
        TreeNodeInfo info = (TreeNodeInfo)defaultMutableParentNode.getUserObject();
        if (newSelectionType == 1) {
            if (info.getSelected() != 1) {
                info.setSelected(1);
                this.treeModel.nodeChanged(defaultMutableParentNode);
            }
            this.setParentSelectionType(defaultMutableParentNode, 1);
            return;
        }
        for (int i = 0; i < defaultMutableParentNode.getChildCount(); ++i) {
            TreeNodeInfo childInfo = (TreeNodeInfo)((DefaultMutableTreeNode)defaultMutableParentNode.getChildAt(i)).getUserObject();
            if (childInfo.getSelected() == newSelectionType) continue;
            if (info.getSelected() != 1) {
                info.setSelected(1);
                this.treeModel.nodeChanged(defaultMutableParentNode);
            }
            this.setParentSelectionType(defaultMutableParentNode, 1);
            return;
        }
        if (info.getSelected() != newSelectionType) {
            info.setSelected(newSelectionType);
            this.treeModel.nodeChanged(defaultMutableParentNode);
        }
        this.setParentSelectionType(defaultMutableParentNode, newSelectionType);
    }

    private void setSelectionType(TreeNode selectedNode, int newSelectionType) {
        TreeNodeInfo info = (TreeNodeInfo)((DefaultMutableTreeNode)selectedNode).getUserObject();
        if (info.getSelected() != newSelectionType) {
            info.setSelected(newSelectionType);
            this.treeModel.nodeChanged(selectedNode);
        }
        for (int i = 0; i < selectedNode.getChildCount(); ++i) {
            this.setSelectionType(selectedNode.getChildAt(i), newSelectionType);
        }
    }

    @Override
    public void show() {
        this.createMapSubTrees(this.topNode);
        if (this.topNode.getChildCount() == 0) {
            JOptionPane.showMessageDialog(this.parentComponent, TextUtils.getText((String)"attributes_no_import_candidates_found"), this.getTitle(), 1);
            return;
        }
        this.treeModel.reload();
        if (this.renderer == null) {
            this.renderer = new MyRenderer();
        }
        this.tree.setCellRenderer(this.renderer);
        this.setLocationRelativeTo(this.parentComponent);
        this.pack();
        super.show();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        int newSelectionType;
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return;
        }
        TreeNodeInfo info = (TreeNodeInfo)selectedNode.getUserObject();
        switch (info.getSelected()) {
            case 0: {
                newSelectionType = 2;
                break;
            }
            default: {
                newSelectionType = 0;
            }
        }
        this.setSelectionType(selectedNode, newSelectionType);
        this.setParentSelectionType(selectedNode, newSelectionType);
        this.tree.clearSelection();
    }

    static /* synthetic */ IconStore access$000() {
        return STORE;
    }

    private static class TreeNodeInfo {
        private static final int FULL_SELECTED = 0;
        private static final int NOT_SELECTED = 2;
        private static final int PARTIAL_SELECTED = 1;
        private final String info;
        private int selected;

        public TreeNodeInfo(String info) {
            this.info = info;
            this.selected = 2;
        }

        String getInfo() {
            return this.info;
        }

        int getSelected() {
            return this.selected;
        }

        void setSelected(int selected) {
            this.selected = selected;
        }

        public String toString() {
            return this.info;
        }
    }

    private static class MyRenderer
    extends DefaultTreeCellRenderer {
        static final Icon iconFull = ImportAttributesDialog.access$000().getUIIcon("ok_button.svg").getIcon();
        static final Icon iconNotSelected = ImportAttributesDialog.access$000().getUIIcon("cancel_button.svg").getIcon();
        static final Icon iconPartial = ImportAttributesDialog.access$000().getUIIcon("Forward24.svg").getIcon();
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, false, expanded, leaf, row, false);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            TreeNodeInfo info = (TreeNodeInfo)node.getUserObject();
            switch (info.getSelected()) {
                case 0: {
                    this.setIcon(iconFull);
                    break;
                }
                case 1: {
                    this.setIcon(iconPartial);
                    break;
                }
                case 2: {
                    this.setIcon(iconNotSelected);
                }
            }
            return this;
        }
    }

    private static class AttributeTreeNodeInfo
    extends TreeNodeInfo {
        private final boolean restricted;

        public AttributeTreeNodeInfo(String info, boolean restricted) {
            super(info);
            this.restricted = restricted;
        }

        boolean isRestricted() {
            return this.restricted;
        }
    }
}

