/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.URL;
import javax.swing.Timer;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.undo.UndoHandler;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.INodeDuplicator;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.DoAutomaticSave;
import org.freeplane.features.url.mindmapmode.DummyLockManager;
import org.freeplane.features.url.mindmapmode.LockManager;
import org.freeplane.features.url.mindmapmode.MFileManager;

public class MMapModel
extends MapModel {
    private static int unnamedMapsNumber = 1;
    private static final long UNKNOWN_MODIFICATION_TIME = -1L;
    private LockManager lockManager = ResourceController.getResourceController().getBooleanProperty("experimental_file_locking_on") ? new LockManager() : new DummyLockManager();
    private Timer timerForAutomaticSaving;
    private int titleNumber = 0;
    private boolean autosaveEnabled = false;
    private long lastKnownModificationTime = -1L;

    public MMapModel(INodeDuplicator nodeDuplicator) {
        super(nodeDuplicator);
    }

    public void setURL(URL v) {
        super.setURL(v);
        this.updateLastKnownFileModificationTime();
    }

    public void updateLastKnownFileModificationTime() {
        this.lastKnownModificationTime = this.getFileModificationTime();
    }

    private long getFileModificationTime() {
        File file = this.getFile();
        long lastKnownModificationTime = file != null && file.exists() ? file.lastModified() : -1L;
        return lastKnownModificationTime;
    }

    public boolean hasExternalFileChanged() {
        boolean hasTimeChanged;
        long fileModificationTime = this.getFileModificationTime();
        boolean bl = hasTimeChanged = fileModificationTime != this.lastKnownModificationTime && fileModificationTime != -1L;
        if (hasTimeChanged) {
            this.lastKnownModificationTime = fileModificationTime;
        }
        return hasTimeChanged;
    }

    public void beforeViewCreated() {
        if (!this.containsExtension(IUndoHandler.class)) {
            this.addExtension(IUndoHandler.class, (IExtension)new UndoHandler((MapModel)this));
        }
    }

    public void enableAutosave() {
        Controller.getCurrentController().getViewController().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!MMapModel.this.autosaveEnabled) {
                    MMapModel.this.autosaveEnabled = true;
                    MMapModel.this.scheduleTimerForAutomaticSaving();
                }
            }
        });
    }

    public void releaseResources() {
        this.getLockManager().release();
        if (this.getTimerForAutomaticSaving() != null) {
            this.getTimerForAutomaticSaving().stop();
        }
        this.autosaveEnabled = false;
        super.releaseResources();
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public Timer getTimerForAutomaticSaving() {
        return this.timerForAutomaticSaving;
    }

    public String getTitle() {
        URL url = this.getURL();
        if (url != null) {
            File file = this.getFile();
            if (file != null) {
                String fileName = file.getName();
                if (fileName.endsWith(".mm")) {
                    return fileName.substring(0, fileName.length() - ".mm".length());
                }
                return fileName;
            }
            return url.toString();
        }
        if (this.titleNumber == 0) {
            this.titleNumber = unnamedMapsNumber++;
        }
        return TextUtils.getText((String)"mindmap") + this.titleNumber;
    }

    public void scheduleTimerForAutomaticSaving() {
        if (!(UrlManager.getController() instanceof MFileManager) || GraphicsEnvironment.isHeadless() || !this.autosaveEnabled) {
            return;
        }
        int numberOfTempFiles = Integer.parseInt(ResourceController.getResourceController().getProperty("number_of_different_files_for_automatic_save"));
        if (numberOfTempFiles == 0) {
            return;
        }
        boolean filesShouldBeDeletedAfterShutdown = ResourceController.getResourceController().getBooleanProperty("delete_automatic_saves_at_exit");
        int delay = ResourceController.getResourceController().getTimeProperty("time_for_automatic_save");
        if (delay == 0) {
            return;
        }
        Timer timer = new Timer(delay, new DoAutomaticSave(this, numberOfTempFiles, filesShouldBeDeletedAfterShutdown));
        timer.setRepeats(true);
        timer.start();
        this.timerForAutomaticSaving = timer;
    }

    public boolean isUndoActionRunning() {
        IUndoHandler undoHandler = (IUndoHandler)this.getExtension(IUndoHandler.class);
        return undoHandler != null && undoHandler.isUndoActionRunning();
    }
}

