/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.url.mindmapmode.TemplateManager;
import org.freeplane.view.swing.features.filepreview.MindMapPreview;

class TemplateChooser {
    private final JCheckBox follow;
    private Box verticalBox;
    private JCheckBox mDontShowAgainBox;
    private JComboBox<String> templateComboBox;
    private static final TemplateManager templateManager = TemplateManager.INSTANCE;

    public TemplateChooser() {
        ResourceController resourceController = ResourceController.getResourceController();
        String standardTemplatePath = resourceController.getProperty("standard_template");
        TreeSet<String> availableMapTemplates = templateManager.collectAvailableMapTemplates();
        availableMapTemplates.add(standardTemplatePath);
        this.verticalBox = Box.createVerticalBox();
        final MindMapPreview mindMapPreview = new MindMapPreview();
        this.templateComboBox = new JComboBox<String>(new Vector<String>(availableMapTemplates));
        this.templateComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    mindMapPreview.updateView(templateManager.existingTemplateFile(e.getItem().toString()));
                }
            }
        });
        this.templateComboBox.setSelectedItem(standardTemplatePath);
        this.templateComboBox.setAlignmentX(0.0f);
        this.verticalBox.add(this.templateComboBox);
        mindMapPreview.setAlignmentX(0.0f);
        this.verticalBox.add((Component)mindMapPreview);
        this.follow = new JCheckBox();
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)this.follow, (String)TextUtils.getRawText((String)"followMindMap"));
        this.follow.setAlignmentX(0.0f);
        this.follow.setSelected(false);
        this.verticalBox.add(this.follow);
        String checkBoxText = TextUtils.getRawText((String)"OptionalDontShowMeAgainDialog.rememberMyDescision");
        this.mDontShowAgainBox = new JCheckBox();
        this.mDontShowAgainBox.setAlignmentX(0.0f);
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)this.mDontShowAgainBox, (String)checkBoxText);
        this.verticalBox.add(this.mDontShowAgainBox);
    }

    File chosenTemplateFile() {
        int option = JOptionPane.showConfirmDialog(UITools.getCurrentFrame(), this.verticalBox, TextUtils.getText((String)"select_template"), -1);
        String selectedTemplate = (String)this.templateComboBox.getSelectedItem();
        if (option == -1) {
            return null;
        }
        if (this.mDontShowAgainBox.isSelected()) {
            ResourceController resourceController = ResourceController.getResourceController();
            resourceController.setProperty("skip_template_selection", true);
            resourceController.setProperty("follow_mind_map_by_default", this.follow.isSelected());
            resourceController.setProperty("standard_template", selectedTemplate);
        }
        return templateManager.existingTemplateFile(selectedTemplate);
    }

    public boolean isConnectChecked() {
        return this.follow.isSelected();
    }
}

