/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.lifecycle.Unfinished;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.BinOpGen;
import ghidra.pcode.emu.jit.gen.op.IntAddOpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitIntCarryOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public enum IntCarryOpGen implements BinOpGen<JitIntCarryOp>
{
    GEN;


    private void generateMpIntCarry(JitCodeGenerator gen, JitType.MpIntJitType type, MethodVisitor mv) {
        int i;
        int legCount = type.legsAlloc();
        int remSize = type.partialSize();
        int firstIndex = gen.getAllocationModel().nextFreeLocal();
        Label start = new Label();
        Label end = new Label();
        mv.visitLabel(start);
        for (i = 0; i < legCount; ++i) {
            mv.visitLocalVariable("temp" + i, Type.getDescriptor(Integer.TYPE), null, start, end, firstIndex + i);
            mv.visitVarInsn(54, firstIndex + i);
        }
        for (i = 0; i < legCount; ++i) {
            boolean takesCarry = i != 0;
            IntAddOpGen.generateMpIntLegAdd(gen, firstIndex + i, takesCarry, true, mv);
        }
        if (remSize == 0) {
            mv.visitLdcInsn((Object)32);
        } else {
            mv.visitLdcInsn((Object)(remSize * 8));
        }
        mv.visitInsn(125);
        TypeConversions.generateLongToInt(JitType.LongJitType.I8, JitType.IntJitType.I4, mv);
        mv.visitLdcInsn((Object)1);
        mv.visitInsn(126);
        mv.visitLabel(end);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public JitType afterLeft(JitCodeGenerator gen, JitIntCarryOp op, JitType lType, JitType rType, MethodVisitor rv) {
        v0 = lType = TypeConversions.forceUniformZExt(lType, rType, rv);
        Objects.requireNonNull(v0);
        var6_6 = v0;
        var7_8 = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.IntJitType.class, JitType.LongJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)var6_6, var7_8)) {
                case 0: {
                    var8_9 = (JitType.IntJitType)var6_6;
                    size = var10_11 = var8_9.size();
                    if (size == 4) ** GOTO lbl15
                    var7_8 = 1;
                    continue block10;
lbl15:
                    // 1 sources

                    rv.visitInsn(89);
                    break block10;
                }
                case 1: {
                    lt = (JitType.IntJitType)var6_6;
                    break block10;
                }
                case 2: {
                    var11_13 = (JitType.LongJitType)var6_6;
                    size = var13_15 = var11_13.size();
                    if (size == 8) ** GOTO lbl27
                    var7_8 = 3;
                    continue block10;
lbl27:
                    // 1 sources

                    rv.visitInsn(92);
                    break block10;
                }
                case 3: {
                    lt = (JitType.LongJitType)var6_6;
                    break block10;
                }
                case 4: {
                    lt = (JitType.MpIntJitType)var6_6;
                    Unfinished.TODO((String)"MpInt", (Object[])new Object[0]);
                    break block10;
                }
                default: {
                    throw new AssertionError();
                }
            }
            break;
        }
        return lType;
        catch (Throwable var6_7) {
            throw new MatchException(var6_7.toString(), var6_7);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JitType generateBinOpRunCode(JitCodeGenerator gen, JitIntCarryOp op, JitControlFlowModel.JitBlock block, JitType lType, JitType rType, MethodVisitor rv) {
        JitType jitType = rType = TypeConversions.forceUniformZExt(rType, lType, rv);
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        block17: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
                case 0: {
                    int n3;
                    int n2;
                    JitType.IntJitType intJitType = (JitType.IntJitType)jitType2;
                    try {
                        n2 = intJitType.size();
                        n3 = 0;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    block18: while (true) {
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Integer.class}, (Object)n2, n3)) {
                            case 0: {
                                int size = n2;
                                if (size == 4) {
                                    rv.visitInsn(96);
                                    rv.visitInsn(95);
                                    rv.visitMethodInsn(184, GenConsts.NAME_INTEGER, "compareUnsigned", GenConsts.MDESC_INTEGER__COMPARE_UNSIGNED, false);
                                    rv.visitLdcInsn((Object)31);
                                    rv.visitInsn(124);
                                    return JitType.IntJitType.I1;
                                }
                                n3 = 1;
                                continue block18;
                            }
                            case 1: {
                                int size = n2;
                                rv.visitInsn(96);
                                rv.visitLdcInsn((Object)(size * 8));
                                rv.visitInsn(122);
                                rv.visitLdcInsn((Object)1);
                                rv.visitInsn(126);
                                return JitType.IntJitType.I1;
                            }
                        }
                        break;
                    }
                    n = 1;
                    continue block17;
                }
                case 1: {
                    int n5;
                    int n4;
                    JitType.LongJitType longJitType = (JitType.LongJitType)jitType2;
                    {
                        n4 = longJitType.size();
                        n5 = 0;
                    }
                    block19: while (true) {
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Integer.class}, (Object)n4, n5)) {
                            case 0: {
                                int size = n4;
                                if (size == 8) {
                                    rv.visitInsn(97);
                                    rv.visitInsn(94);
                                    rv.visitInsn(88);
                                    rv.visitMethodInsn(184, GenConsts.NAME_LONG, "compareUnsigned", GenConsts.MDESC_LONG__COMPARE_UNSIGNED, false);
                                    rv.visitLdcInsn((Object)31);
                                    rv.visitInsn(124);
                                    return JitType.IntJitType.I1;
                                }
                                n5 = 1;
                                continue block19;
                            }
                            case 1: {
                                int size = n4;
                                rv.visitInsn(97);
                                rv.visitLdcInsn((Object)(size * 8));
                                rv.visitInsn(123);
                                rv.visitInsn(136);
                                rv.visitLdcInsn((Object)1);
                                rv.visitInsn(126);
                                return JitType.IntJitType.I1;
                            }
                        }
                        break;
                    }
                    n = 2;
                    continue block17;
                }
                case 2: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                    if (t.size() == lType.size()) {
                        this.generateMpIntCarry(gen, t, rv);
                        return JitType.IntJitType.I1;
                    }
                    n = 3;
                    continue block17;
                }
                case 3: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                    return (JitType)Unfinished.TODO((String)"MpInt of differing sizes", (Object[])new Object[0]);
                }
            }
            break;
        }
        throw new AssertionError();
    }
}

