/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.ColorValue;
import generic.theme.GThemeValueMap;
import generic.theme.ThemeEvent;

public class ColorChangedThemeEvent
extends ThemeEvent {
    private final ColorValue color;
    private final GThemeValueMap values;

    public ColorChangedThemeEvent(GThemeValueMap values, ColorValue color) {
        this.values = values;
        this.color = color;
    }

    @Override
    public boolean isColorChanged(String id) {
        if (id.equals(this.color.getId())) {
            return true;
        }
        ColorValue testValue = this.values.getColor(id);
        if (testValue == null) {
            return false;
        }
        return testValue.inheritsFrom(this.color.getId(), this.values);
    }

    @Override
    public boolean hasAnyColorChanged() {
        return true;
    }
}

