/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.protocol.ghidra.GhidraProtocolHandler;
import ghidra.framework.protocol.ghidra.GhidraURLConnection;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.NotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Handler
extends URLStreamHandler {
    private static final String MY_PARENT_PACKAGE = "ghidra.framework.protocol";
    private static final String PROTOCOL_HANDLER_PKGS_PROPERTY = "java.protocol.handler.pkgs";
    private static Collection<GhidraProtocolHandler> protocolHandlers;

    public static void registerHandler() {
        Object pkgs = System.getProperty(PROTOCOL_HANDLER_PKGS_PROPERTY);
        if (pkgs != null) {
            if (((String)pkgs).indexOf(MY_PARENT_PACKAGE) >= 0) {
                return;
            }
            pkgs = (String)pkgs + "|ghidra.framework.protocol";
        } else {
            pkgs = MY_PARENT_PACKAGE;
        }
        System.setProperty(PROTOCOL_HANDLER_PKGS_PROPERTY, (String)pkgs);
    }

    public static boolean isSupportedURL(URL url) {
        if (!"ghidra".equals(url.getProtocol())) {
            return false;
        }
        if (url.getAuthority() != null) {
            return true;
        }
        try {
            return Handler.getProtocolExtensionHandler(url) != null;
        }
        catch (NotFoundException | MalformedURLException e) {
            return false;
        }
    }

    private static GhidraProtocolHandler getProtocolExtensionHandler(URL url) throws MalformedURLException, NotFoundException {
        String path = url.getPath();
        int index = path.indexOf("://");
        if (index <= 0) {
            throw new MalformedURLException("invalid ghidra URL: " + String.valueOf(url));
        }
        String extensionName = path.substring(0, index);
        GhidraProtocolHandler protocolHandler = Handler.findGhidraProtocolHandler(extensionName);
        if (protocolHandler == null) {
            throw new NotFoundException("ghidra protocol extension handler (" + extensionName + ") not found");
        }
        return protocolHandler;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        if (!"ghidra".equals(url.getProtocol())) {
            throw new IllegalArgumentException("unsupported URL protocol: " + url.getProtocol());
        }
        if (url.getAuthority() == null && !url.getPath().startsWith("/")) {
            try {
                GhidraProtocolHandler protocolHandler = Handler.getProtocolExtensionHandler(url);
                url = new URL(url.toExternalForm().substring("ghidra".length() + 1));
                return new GhidraURLConnection(url, protocolHandler);
            }
            catch (NotFoundException e) {
                throw new IOException("unsupported ghidra URL", e);
            }
        }
        return new GhidraURLConnection(url);
    }

    private static void loadGhidraProtocolHandlers() {
        protocolHandlers = new ArrayList<GhidraProtocolHandler>();
        List classes = ClassSearcher.getClasses(GhidraProtocolHandler.class);
        for (Class c : classes) {
            try {
                protocolHandlers.add((GhidraProtocolHandler)c.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                Msg.error(Handler.class, (Object)("Failed to instantiate ghidra protocol extension handler: " + c.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GhidraProtocolHandler findGhidraProtocolHandler(String extensionName) {
        Class<Handler> clazz = Handler.class;
        synchronized (Handler.class) {
            if (protocolHandlers == null) {
                Handler.loadGhidraProtocolHandlers();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (GhidraProtocolHandler handler : protocolHandlers) {
                if (!handler.isExtensionSupported(extensionName)) continue;
                return handler;
            }
            return null;
        }
    }
}

