/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;

public class ExportMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4408;
    private int ordinal;
    private boolean isConstant;
    private boolean isData;
    private boolean isPrivate;
    private boolean noName;
    private boolean ordinalExplicitlyAssigned;
    private boolean isForwarder;
    private String name;

    public ExportMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.ordinal = reader.parseUnsignedShortVal();
        int flags = reader.parseUnsignedShortVal();
        this.processFlags(flags);
        this.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
        reader.align4();
    }

    @Override
    public int getPdbId() {
        return 4408;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: Ordinal = %d%s, ", this.getSymbolTypeName(), this.ordinal, this.ordinalExplicitlyAssigned ? "" : " (implicit)"));
        builder.append(this.isConstant ? "CONSTANT, " : "");
        builder.append(this.isData ? "DATA, " : "");
        builder.append(this.isPrivate ? "PRIVATE, " : "");
        builder.append(this.noName ? "NONAME, " : "");
        builder.append(this.isForwarder ? "FORWARDER, " : "");
        builder.append(this.name);
    }

    @Override
    protected String getSymbolTypeName() {
        return "EXPORT";
    }

    protected void processFlags(int flagsIn) {
        this.isConstant = (flagsIn & 1) == 1;
        this.isData = ((flagsIn >>= 1) & 1) == 1;
        this.isPrivate = ((flagsIn >>= 1) & 1) == 1;
        this.noName = ((flagsIn >>= 1) & 1) == 1;
        this.ordinalExplicitlyAssigned = ((flagsIn >>= 1) & 1) == 1;
        this.isForwarder = ((flagsIn >>= 1) & 1) == 1;
    }
}

