/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver;

import java.util.Objects;
import pdb.symbolserver.SymbolFileInfo;
import pdb.symbolserver.SymbolServer;

public class SymbolFileLocation {
    private final SymbolFileInfo fileInfo;
    private final String path;
    private final SymbolServer symbolServer;

    public SymbolFileLocation(String path, SymbolServer symbolServer, SymbolFileInfo fileInfo) {
        this.path = path;
        this.symbolServer = symbolServer;
        this.fileInfo = fileInfo;
    }

    public String getPath() {
        return this.path;
    }

    public SymbolServer getSymbolServer() {
        return this.symbolServer;
    }

    public SymbolFileInfo getFileInfo() {
        return this.fileInfo;
    }

    public boolean isExactMatch(SymbolFileInfo otherSymbolFileInfo) {
        return this.fileInfo.isExactMatch(otherSymbolFileInfo);
    }

    public String getLocationStr() {
        return this.symbolServer.getFileLocation(this.path);
    }

    public String toString() {
        return this.path + " in " + this.symbolServer.getName() + " for " + this.fileInfo.getDescription();
    }

    public int hashCode() {
        return Objects.hash(this.fileInfo, this.path, this.symbolServer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SymbolFileLocation other = (SymbolFileLocation)obj;
        return Objects.equals(this.fileInfo, other.fileInfo) && Objects.equals(this.path, other.path) && this.symbolServer == other.symbolServer;
    }
}

