/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.data;

import ghidra.program.model.data.ISF.IsfBuiltIn;
import ghidra.program.model.data.ISF.IsfComposite;
import ghidra.program.model.data.ISF.IsfDataTypeWriter;
import ghidra.program.model.data.ISF.IsfEnum;
import ghidra.program.model.data.ISF.IsfFunction;
import ghidra.program.model.data.ISF.IsfObject;
import ghidra.program.model.data.ISF.IsfTypedObject;
import ghidra.program.model.data.ISF.IsfTypedefBase;
import ghidra.program.model.data.ISF.IsfTypedefPointer;
import ghidra.program.model.data.ISF.IsfTypedefUser;
import sarif.export.SarifObject;
import sarif.managers.DataTypesSarifMgr;

public class SarifDataType
extends SarifObject {
    public SarifDataType(IsfObject obj, IsfDataTypeWriter writer) {
        super("DataType", DataTypesSarifMgr.KEY, writer.getTree((Object)obj));
        this.message.addProperty("text", this.objToMessage(obj));
    }

    private String objToMessage(IsfObject obj) {
        if (obj instanceof IsfComposite) {
            return ((IsfComposite)obj).kind.equals("struct") ? "DT.Struct" : "DT.Union";
        }
        if (obj instanceof IsfEnum) {
            return "DT.Enum";
        }
        if (obj instanceof IsfFunction) {
            return "DT.Function";
        }
        if (obj instanceof IsfTypedefBase || obj instanceof IsfTypedefPointer || obj instanceof IsfTypedefUser) {
            return "DT.Typedef";
        }
        if (obj instanceof IsfTypedObject) {
            return "DT.TypedObject";
        }
        if (obj instanceof IsfBuiltIn) {
            return "DT.Builtin";
        }
        return "DT.Base";
    }
}

