/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.io;

import org.catacombae.hfsexplorer.io.BasicSynchronizedReadableRandomAccessStream;
import org.catacombae.hfsexplorer.io.SynchronizedReadableRandomAccess;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;

public class SynchronizedReadableRandomAccessStream
extends BasicSynchronizedReadableRandomAccessStream
implements SynchronizedReadableRandomAccess {
    private ReadableRandomAccessStream ras;
    private long refCount;
    private boolean closed = false;

    public SynchronizedReadableRandomAccessStream(ReadableRandomAccessStream sourceStream) {
        this.ras = sourceStream;
    }

    public ReadableRandomAccessStream getSourceStream() {
        return this.ras;
    }

    public synchronized int readFrom(long pos, byte[] b, int off, int len) throws RuntimeIOException {
        long oldFP = this.getFilePointer();
        if (oldFP != pos) {
            this.seek(pos);
        }
        int res = this.read(b, off, len);
        if (oldFP != pos) {
            this.seek(oldFP);
        }
        return res;
    }

    public synchronized long skipFrom(long pos, long length) throws RuntimeIOException {
        long newPos = pos + length;
        long streamLength = this.length();
        long res = newPos > streamLength ? streamLength - pos : length;
        return res;
    }

    public synchronized long remainingLength() throws RuntimeIOException {
        return this.length() - this.getFilePointer();
    }

    public synchronized void close() throws RuntimeIOException {
        if (this.refCount != 0L) {
            throw new RuntimeIOException(this.refCount + " instances are still using this stream!");
        }
        this.ras.close();
        this.closed = true;
    }

    public synchronized long getFilePointer() throws RuntimeIOException {
        return this.ras.getFilePointer();
    }

    public synchronized long length() throws RuntimeIOException {
        return this.ras.length();
    }

    public synchronized int read() throws RuntimeIOException {
        return this.ras.read();
    }

    public synchronized int read(byte[] b) throws RuntimeIOException {
        return this.ras.read(b);
    }

    public synchronized int read(byte[] b, int off, int len) throws RuntimeIOException {
        return this.ras.read(b, off, len);
    }

    public synchronized void seek(long pos) throws RuntimeIOException {
        this.ras.seek(pos);
    }

    public synchronized void addReference(Object referrer) {
        if (!this.closed) {
            ++this.refCount;
        } else {
            throw new RuntimeIOException("Stream is closed!");
        }
    }

    public synchronized void removeReference(Object referrer) {
        --this.refCount;
    }
}

