/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint.actions;

import docking.DialogComponentProvider;
import docking.action.MenuData;
import docking.widgets.dialogs.InputDialog;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangReturnType;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompiler.taint.TaintLabel;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintAbstractDecompilerAction;
import ghidra.program.model.listing.Function;
import ghidra.util.UndefinedFunction;

public class TaintSetSizeAction
extends TaintAbstractDecompilerAction {
    private TaintPlugin plugin;

    public TaintSetSizeAction(TaintPlugin plugin) {
        super("Set length");
        this.setPopupMenuData(new MenuData(new String[]{"Taint", "Set length"}, "Decompile"));
        this.plugin = plugin;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        if (this.plugin.getTaintState() == null) {
            return false;
        }
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFieldToken) {
            return true;
        }
        if (tokenAtCursor.Parent() instanceof ClangReturnType) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFuncNameToken) {
            return true;
        }
        return tokenAtCursor.isVariableRef();
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        TaintLabel label = this.plugin.getTaintState().getLabelForToken(TaintState.MarkType.SOURCE, context.getTokenAtCursor());
        if (label != null) {
            InputDialog dialog = new InputDialog("Update length", "Length", Integer.toHexString(label.getSize()));
            this.plugin.getTool().showDialog((DialogComponentProvider)dialog);
            if (dialog.isCanceled()) {
                return;
            }
            String val = dialog.getValue();
            label.setSize(Integer.parseInt(val, 16));
        }
    }
}

