/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;

public class RemoveReferenceCmd
implements Command<Program> {
    private Address fromAddr;
    private Address toAddr;
    private int opIndex;
    private String status;

    public RemoveReferenceCmd(Reference ref) {
        this.fromAddr = ref.getFromAddress();
        this.toAddr = ref.getToAddress();
        this.opIndex = ref.getOperandIndex();
    }

    public RemoveReferenceCmd(Address fromAddr, Address toAddr, int opIndex) {
        this.fromAddr = fromAddr;
        this.toAddr = toAddr;
        this.opIndex = opIndex;
    }

    public boolean applyTo(Program program) {
        ReferenceManager refMgr = program.getReferenceManager();
        Reference ref = refMgr.getReference(this.fromAddr, this.toAddr, this.opIndex);
        if (ref != null) {
            refMgr.delete(ref);
            RemoveReferenceCmd.fixupReferencedVariable(program, ref);
            return true;
        }
        this.status = "Reference not found";
        return false;
    }

    static void fixupReferencedVariable(Program p, Reference deletedRef) {
        Symbol s;
        Variable var = p.getReferenceManager().getReferencedVariable(deletedRef);
        if (var != null && (s = var.getSymbol()) != null && !(var instanceof Parameter) && s.getSource() == SourceType.DEFAULT && s.getReferenceCount() == 0) {
            s.delete();
        }
    }

    public String getStatusMsg() {
        return this.status;
    }

    public String getName() {
        return "Remove Reference";
    }
}

