/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.archive.InvalidFileArchive;
import ghidra.app.plugin.core.datamgr.tree.InvalidArchiveNode;
import ghidra.util.HTMLUtilities;
import java.awt.Component;
import javax.swing.tree.TreePath;

public class RemoveInvalidArchiveFromProgramAction
extends DockingAction {
    private DataTypeManagerPlugin plugin;

    public RemoveInvalidArchiveFromProgramAction(DataTypeManagerPlugin plugin) {
        super("Remove Invalid Archive", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Remove Archive From Program"}, null, "File"));
        this.setDescription("Removes the archive from program and tool");
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return false;
        }
        TreePath path = selectionPaths[0];
        GTreeNode node = (GTreeNode)path.getLastPathComponent();
        return node instanceof InvalidArchiveNode;
    }

    public void actionPerformed(ActionContext context) {
        GTree gtree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length != 1) {
            return;
        }
        Object pathComponent = selectionPaths[0].getLastPathComponent();
        InvalidArchiveNode invalidArchiveNode = (InvalidArchiveNode)((Object)pathComponent);
        if (OptionDialog.showOptionDialog((Component)gtree, (String)"Confirm Remove Invalid Archive(s)", (String)("<html><b>Are you sure you want to delete archive: " + HTMLUtilities.escapeHTML((String)invalidArchiveNode.getName()) + " from the program?<br><br><font color=\"" + GThemeDefaults.Colors.Messages.ERROR.toHexString() + "\">(WARNING: This action will disassociate all datatypes in the program from this archive.)</font></b>"), (String)"Yes", (int)3) != 1) {
            return;
        }
        Archive archive = invalidArchiveNode.getArchive();
        DataTypeManagerHandler dataTypeManagerHandler = this.plugin.getDataTypeManagerHandler();
        dataTypeManagerHandler.removeInvalidArchive((InvalidFileArchive)archive);
    }
}

