/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.overview;

import docking.action.DockingActionIf;
import generic.theme.GColor;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.overview.OverviewColorService;
import ghidra.app.services.GoToService;
import ghidra.app.util.viewer.listingpanel.OverviewProvider;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.task.SwingUpdateManager;
import help.Help;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class OverviewColorComponent
extends JPanel
implements OverviewProvider {
    private static final Color DEFAULT_COLOR = new GColor("color.bg.plugin.overview.defalt");
    private OverviewColorService service;
    private Color[] colors = new Color[0];
    private final SwingUpdateManager refreshUpdater = new SwingUpdateManager(100, 15000, () -> this.doRefresh());
    private AddressIndexMap map;
    private Navigatable navigatable;
    private PluginTool tool;
    private List<DockingActionIf> actions;

    public OverviewColorComponent(PluginTool tool, OverviewColorService overviewColorService) {
        this.tool = tool;
        this.service = overviewColorService;
        overviewColorService.setOverviewComponent(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    Address address = OverviewColorComponent.this.getAddress(e.getY());
                    OverviewColorComponent.this.gotoAddress(address);
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this);
        Help.getHelpService().registerHelp((Object)this, this.service.getHelpLocation());
        this.actions = this.service.getActions();
    }

    public void installActions() {
        if (this.actions == null) {
            return;
        }
        for (DockingActionIf action : this.actions) {
            this.tool.addAction(action);
        }
    }

    public void uninstallActions() {
        if (this.actions == null) {
            return;
        }
        for (DockingActionIf action : this.actions) {
            this.tool.removeAction(action);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(16, 1);
    }

    protected void gotoAddress(Address address) {
        GoToService gotoService = (GoToService)this.tool.getService(GoToService.class);
        if (gotoService != null) {
            gotoService.goTo(this.navigatable, address);
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Address address = this.getAddress(e.getY());
        return this.service.getToolTipText(address);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int pixelCount = this.getOverviewPixelCount();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width - 1, this.getHeight() - 1);
        if (this.service.getProgram() == null) {
            return;
        }
        for (int i = 0; i < pixelCount; ++i) {
            Color color = this.getColor(i);
            g.setColor(color);
            g.fillRect(1, i, width - 3, 1);
        }
        if (this.colors.length != pixelCount) {
            this.colors = new Color[pixelCount];
            this.refreshUpdater.updateLater();
        }
    }

    private Color getColor(int index) {
        if (this.colors != null && index < this.colors.length) {
            return this.colors[index];
        }
        return DEFAULT_COLOR;
    }

    private int getOverviewPixelCount() {
        return Math.max(this.getHeight(), 0);
    }

    private void doRefresh() {
        if (this.map == null) {
            return;
        }
        BigInteger indexCount = this.map.getIndexCount();
        if (indexCount.equals(BigInteger.ZERO)) {
            Arrays.fill(this.colors, DEFAULT_COLOR);
            this.repaint();
            return;
        }
        BigInteger bigTotal = BigInteger.valueOf(this.colors.length);
        for (int i = 0; i < this.colors.length; ++i) {
            if (this.colors[i] != null) continue;
            BigInteger index = indexCount.multiply(BigInteger.valueOf(i)).divide(bigTotal);
            Address address = this.map.getAddress(index);
            this.colors[i] = this.service.getColor(address);
        }
        this.repaint();
    }

    private Address getAddress(int pixelIndex) {
        BigInteger bigHeight = BigInteger.valueOf(this.getOverviewPixelCount());
        BigInteger bigPixelIndex = BigInteger.valueOf(pixelIndex);
        BigInteger bigIndex = this.map.getIndexCount().multiply(bigPixelIndex).divide(bigHeight);
        return this.map.getAddress(bigIndex);
    }

    private int getPixelIndex(Address address) {
        BigInteger addressIndex = this.map.getIndex(address);
        if (addressIndex == null) {
            return -1;
        }
        BigInteger bigHeight = BigInteger.valueOf(this.getOverviewPixelCount());
        BigInteger indexCount = this.map.getIndexCount();
        return addressIndex.multiply(bigHeight).divide(indexCount).intValue();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setProgram(Program program, AddressIndexMap map) {
        this.map = map;
        this.colors = new Color[this.getOverviewPixelCount()];
        this.refreshUpdater.updateLater();
    }

    @Override
    public void setNavigatable(Navigatable n) {
        this.navigatable = n;
    }

    public void refreshAll() {
        this.colors = new Color[this.getOverviewPixelCount()];
        this.refreshUpdater.updateLater();
    }

    public void refresh(Address start, Address end) {
        if (start == null) {
            return;
        }
        if (end == null) {
            end = start;
        }
        int pixelStart = this.getPixelIndex(start);
        int pixelEnd = this.getPixelIndex(end);
        for (int i = pixelStart; i <= pixelEnd; ++i) {
            if (!(i >= 0 & i < this.colors.length)) continue;
            this.colors[i] = null;
        }
        this.refreshUpdater.updateLater();
    }

    public PluginTool getTool() {
        return this.tool;
    }
}

