/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.InvalidDataException;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.io.InputStream;

public class LEB128Info {
    private final long offset;
    private final long value;
    private final int byteLength;

    public static LEB128Info unsigned(BinaryReader reader) throws IOException {
        return LEB128Info.readValue(reader, false);
    }

    public static LEB128Info signed(BinaryReader reader) throws IOException {
        return LEB128Info.readValue(reader, true);
    }

    private LEB128Info(long offset, long value, int byteLength) {
        this.offset = offset;
        this.value = value;
        this.byteLength = byteLength;
    }

    public int asUInt32() throws IOException {
        LEB128Info.ensureInt32u(this.value);
        return (int)this.value;
    }

    public int asInt32() throws IOException {
        LEB128Info.ensureInt32s(this.value);
        return (int)this.value;
    }

    public long asLong() {
        return this.value;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.byteLength;
    }

    public String toString() {
        return String.format("LEB128: value: %d, offset: %d, byteLength: %d", this.value, this.offset, this.byteLength);
    }

    public static LEB128Info readValue(BinaryReader reader, boolean isSigned) throws IOException {
        long offset = reader.getPointerIndex();
        long value = LEB128.read((InputStream)reader.getInputStream(), (boolean)isSigned);
        int size = (int)(reader.getPointerIndex() - offset);
        return new LEB128Info(offset, value, size);
    }

    private static void ensureInt32u(long value) throws IOException {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new InvalidDataException("Value out of range for positive java 32 bit unsigned int: %s".formatted(Long.toUnsignedString(value)));
        }
    }

    private static void ensureInt32s(long value) throws IOException {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new InvalidDataException("Value out of range for java 32 bit signed int: %d".formatted(value));
        }
    }
}

