/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfString;
import ghidra.app.util.bin.format.omf.OmfUtils;
import ghidra.app.util.bin.format.omf.omf.OmfRecordTypes;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OmfNamesRecord
extends OmfRecord {
    private List<OmfString> names = new ArrayList<OmfString>();

    public OmfNamesRecord(BinaryReader reader) throws IOException {
        super(reader);
    }

    @Override
    public void parseData() throws IOException, OmfException {
        while (this.dataReader.getPointerIndex() < this.dataEnd) {
            this.names.add(OmfUtils.readString(this.dataReader));
        }
    }

    public void appendNames(List<String> namelist) {
        namelist.addAll(this.names.stream().map(name -> name.str()).toList());
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(OmfRecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", null);
        for (OmfString name : this.names) {
            struct.add(name.toDataType(), name.getDataTypeSize(), "name", null);
        }
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }
}

