/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GComboBox;
import ghidra.docking.util.LookAndFeelUtils;
import ghidra.features.base.memsearch.bytesource.SearchRegion;
import ghidra.features.base.memsearch.gui.SearchGuiModel;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.program.model.lang.Endian;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

class MemorySearchOptionsPanel
extends JPanel {
    private SearchGuiModel model;
    private GCheckBox caseSensitiveCheckbox;
    private GCheckBox escapeSequencesCheckbox;
    private GCheckBox decimalUnsignedCheckbox;
    private GComboBox<Integer> decimalByteSizeCombo;
    private GComboBox<Charset> charsetCombo;
    private GComboBox<String> endianessCombo;
    private boolean isNimbus;

    MemorySearchOptionsPanel(SearchGuiModel model) {
        super(new BorderLayout());
        this.model = model;
        this.isNimbus = LookAndFeelUtils.isUsingNimbusUI();
        JPanel scrolledPanel = new JPanel((LayoutManager)new VerticalLayout(this.isNimbus ? 8 : 16));
        scrolledPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        scrolledPanel.add(this.buildByteOptionsPanel());
        scrolledPanel.add(this.buildDecimalOptions());
        scrolledPanel.add(this.buildStringOptions());
        scrolledPanel.add(this.buildCodeUnitScopePanel());
        scrolledPanel.add(this.buildMemorySearchRegionsPanel());
        JScrollPane scroll = new JScrollPane(scrolledPanel);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setVerticalScrollBarPolicy(20);
        this.add((Component)scroll, "Center");
        model.addChangeCallback(this::guiModelChanged);
        HelpService helpService = Help.getHelpService();
        helpService.registerHelp((Object)this, new HelpLocation("Search", "Options"));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width += 20;
        return size;
    }

    private JComponent buildMemorySearchRegionsPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(3));
        panel.setBorder(this.createBorder("Search Region Filter"));
        List<SearchRegion> choices = this.model.getMemoryRegionChoices();
        for (SearchRegion region : choices) {
            GCheckBox checkbox = new GCheckBox(region.getName());
            checkbox.setToolTipText(region.getDescription());
            checkbox.setSelected(this.model.isSelectedRegion(region));
            checkbox.addItemListener(e -> this.model.selectRegion(region, checkbox.isSelected()));
            panel.add((Component)checkbox);
        }
        return panel;
    }

    private JComponent buildDecimalOptions() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(3));
        panel.setBorder(this.createBorder("Decimal Options"));
        JPanel innerPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        JLabel label = new JLabel("Size:");
        label.setToolTipText("Size of decimal values in bytes");
        innerPanel.add(label);
        Object[] decimalSizes = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 16};
        this.decimalByteSizeCombo = new GComboBox(decimalSizes);
        this.decimalByteSizeCombo.setSelectedItem((Object)4);
        this.decimalByteSizeCombo.addItemListener(this::byteSizeComboChanged);
        this.decimalByteSizeCombo.setToolTipText("Size of decimal values in bytes");
        innerPanel.add((Component)this.decimalByteSizeCombo);
        panel.add(innerPanel);
        this.decimalUnsignedCheckbox = new GCheckBox("Unsigned");
        this.decimalUnsignedCheckbox.setToolTipText("Sets whether decimal values should be interpreted as unsigned values");
        this.decimalUnsignedCheckbox.addActionListener(e -> this.model.setDecimalUnsigned(this.decimalUnsignedCheckbox.isSelected()));
        panel.add((Component)this.decimalUnsignedCheckbox);
        return panel;
    }

    private void byteSizeComboChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        int byteSize = (Integer)e.getItem();
        this.model.setDecimalByteSize(byteSize);
    }

    private JComponent buildCodeUnitScopePanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        panel.setBorder(this.createBorder("Code Type Filter"));
        GCheckBox instructionsCheckBox = new GCheckBox("Instructions");
        GCheckBox definedDataCheckBox = new GCheckBox("Defined Data");
        GCheckBox undefinedDataCheckBox = new GCheckBox("Undefined Data");
        instructionsCheckBox.setToolTipText("If selected, include matches found in instructions");
        definedDataCheckBox.setToolTipText("If selected, include matches found in defined data");
        undefinedDataCheckBox.setToolTipText("If selected, include matches found in undefined data");
        instructionsCheckBox.setSelected(this.model.includeInstructions());
        definedDataCheckBox.setSelected(this.model.includeDefinedData());
        undefinedDataCheckBox.setSelected(this.model.includeUndefinedData());
        instructionsCheckBox.addActionListener(e -> this.model.setIncludeInstructions(instructionsCheckBox.isSelected()));
        definedDataCheckBox.addActionListener(e -> this.model.setIncludeDefinedData(definedDataCheckBox.isSelected()));
        undefinedDataCheckBox.addActionListener(e -> this.model.setIncludeUndefinedData(undefinedDataCheckBox.isSelected()));
        panel.add((Component)instructionsCheckBox);
        panel.add((Component)definedDataCheckBox);
        panel.add((Component)undefinedDataCheckBox);
        return panel;
    }

    private JComponent buildByteOptionsPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(3, 2));
        panel.setBorder(this.createBorder("Byte Options"));
        Object[] endianess = new String[]{"Big", "Little"};
        this.endianessCombo = new GComboBox(endianess);
        this.endianessCombo.setSelectedIndex(this.model.isBigEndian() ? 0 : 1);
        this.endianessCombo.addItemListener(this::endianessComboChanged);
        this.endianessCombo.setToolTipText("Selects the endianess");
        JTextField alignField = new JTextField(5);
        alignField.setDocument(new RestrictedInputDocument());
        alignField.setName("Alignment");
        alignField.setText(Integer.toString(this.model.getAlignment()));
        alignField.setToolTipText("Filters out matches whose address is not divisible by the alignment value");
        panel.add(new JLabel("Endianess:"));
        panel.add((Component)this.endianessCombo);
        panel.add(new JLabel("Alignment:"));
        panel.add(alignField);
        return panel;
    }

    private void endianessComboChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        String endianString = (String)e.getItem();
        Endian endian = Endian.toEndian((String)endianString);
        this.model.setBigEndian(endian.isBigEndian());
    }

    private JComponent buildStringOptions() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(3));
        Object[] supportedCharsets = new Charset[]{StandardCharsets.US_ASCII, StandardCharsets.UTF_8, StandardCharsets.UTF_16};
        this.charsetCombo = new GComboBox(supportedCharsets);
        this.charsetCombo.setName("Encoding Options");
        this.charsetCombo.setSelectedIndex(0);
        this.charsetCombo.addItemListener(this::encodingComboChanged);
        this.charsetCombo.setToolTipText("Character encoding for translating strings to bytes");
        JPanel innerPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        JLabel label = new JLabel("Encoding:");
        label.setToolTipText("Character encoding for translating strings to bytes");
        innerPanel.add(label);
        innerPanel.add((Component)this.charsetCombo);
        panel.add(innerPanel);
        this.caseSensitiveCheckbox = new GCheckBox("Case Sensitive");
        this.caseSensitiveCheckbox.setSelected(this.model.isCaseSensitive());
        this.caseSensitiveCheckbox.setToolTipText("Allows for case sensitive searching.");
        this.caseSensitiveCheckbox.addActionListener(e -> this.model.setCaseSensitive(this.caseSensitiveCheckbox.isSelected()));
        this.escapeSequencesCheckbox = new GCheckBox("Escape Sequences");
        this.escapeSequencesCheckbox.setSelected(this.model.useEscapeSequences());
        this.escapeSequencesCheckbox.setToolTipText("Allows specifying control characters using escape sequences (i.e., allows \\n to be searched for as a single line feed character).");
        this.escapeSequencesCheckbox.addActionListener(e -> this.model.setUseEscapeSequences(this.escapeSequencesCheckbox.isSelected()));
        panel.setBorder(this.createBorder("String Options"));
        panel.add((Component)this.caseSensitiveCheckbox);
        panel.add((Component)this.escapeSequencesCheckbox);
        return panel;
    }

    private void encodingComboChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        Charset charSet = (Charset)e.getItem();
        this.model.setStringCharset(charSet);
    }

    private void guiModelChanged(SearchSettings oldSettings) {
        this.endianessCombo.setSelectedItem((Object)(this.model.isBigEndian() ? "Big" : "Little"));
        this.caseSensitiveCheckbox.setSelected(this.model.isCaseSensitive());
        this.escapeSequencesCheckbox.setSelected(this.model.useEscapeSequences());
        this.decimalByteSizeCombo.setSelectedItem((Object)this.model.getDecimalByteSize());
        this.decimalUnsignedCheckbox.setSelected(this.model.isDecimalUnsigned());
        this.charsetCombo.setSelectedItem((Object)this.model.getStringCharset());
    }

    private Border createBorder(String name) {
        TitledBorder outerBorder = BorderFactory.createTitledBorder(name);
        if (this.isNimbus) {
            return outerBorder;
        }
        Border innerBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        return BorderFactory.createCompoundBorder(outerBorder, innerBorder);
    }

    private class RestrictedInputDocument
    extends DefaultStyledDocument {
        private RestrictedInputDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String afterOffset;
            String currentText = this.getText(0, this.getLength());
            String beforeOffset = currentText.substring(0, offs);
            String proposedText = beforeOffset + str + (afterOffset = currentText.substring(offs, currentText.length()));
            int alignment = this.getValue(proposedText);
            if (alignment > 0) {
                super.insertString(offs, str, a);
                MemorySearchOptionsPanel.this.model.setAlignment(alignment);
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            String afterOffset;
            String currentText = this.getText(0, this.getLength());
            String beforeOffset = currentText.substring(0, offs);
            String proposedResult = beforeOffset + (afterOffset = currentText.substring(len + offs, currentText.length()));
            int alignment = this.getValue(proposedResult);
            if (alignment > 0) {
                super.remove(offs, len);
                MemorySearchOptionsPanel.this.model.setAlignment(alignment);
            }
        }

        private int getValue(String proposedText) {
            if (proposedText.isBlank()) {
                return 1;
            }
            try {
                return Integer.parseInt(proposedText);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
    }
}

