/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemRef;
import java.io.File;
import java.io.IOException;

public class RefdByteProvider
implements ByteProvider {
    private final FileSystemRef fsRef;
    private final ByteProvider provider;
    private final FSRL fsrl;

    public RefdByteProvider(FileSystemRef fsRef, ByteProvider provider, FSRL fsrl) {
        this.fsRef = fsRef;
        this.provider = provider;
        this.fsrl = fsrl;
    }

    ByteProvider getWrappedByteProvider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
        this.provider.close();
        this.fsRef.close();
    }

    @Override
    public FSRL getFSRL() {
        return this.fsrl;
    }

    @Override
    public File getFile() {
        return this.provider.getFile();
    }

    @Override
    public String getName() {
        return this.fsrl != null ? this.fsrl.getName() : this.provider.getName();
    }

    @Override
    public String getAbsolutePath() {
        return this.fsrl != null ? this.fsrl.getPath() : this.provider.getAbsolutePath();
    }

    @Override
    public long length() throws IOException {
        return this.provider.length();
    }

    @Override
    public boolean isValidIndex(long index) {
        return this.provider.isValidIndex(index);
    }

    @Override
    public byte readByte(long index) throws IOException {
        return this.provider.readByte(index);
    }

    @Override
    public byte[] readBytes(long index, long length) throws IOException {
        return this.provider.readBytes(index, length);
    }

    public String toString() {
        return "ByteProvider " + String.valueOf(this.provider.getFSRL()) + " in file system " + String.valueOf(this.fsRef.getFilesystem());
    }
}

