/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.SwingRunnable;
import ghidra.util.task.TaskListener;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorComponent;
import ghidra.util.worker.Job;
import ghidra.util.worker.Worker;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class RunManager {
    private static final int SHOW_PROGRESS_DELAY = 500;
    private static final String DEFAULT = "Default Panel";
    private static final String PROGRESS = "Progress Panel";
    private CardLayout cardLayout;
    private JPanel progressPanel;
    private final Component defaultComponent;
    private TaskMonitorComponent monitor;
    private final Worker worker;
    private final String runManagerName;
    private TaskListener taskListener;

    public RunManager() {
        this(null, null, null);
    }

    public RunManager(TaskListener listener) {
        this(null, null, listener);
    }

    public RunManager(String name, Component defaultComponent) {
        this(name, defaultComponent, null);
    }

    public RunManager(String name, Component defaultComponent, TaskListener listener) {
        this.runManagerName = name;
        this.defaultComponent = defaultComponent;
        this.taskListener = listener;
        this.createProgressPanel();
        this.worker = new Worker((String)(name == null ? "Run Manager Worker" : "Run Manager Worker: " + name), (TaskMonitor)this.monitor);
        this.worker.setBusyListener(busy -> {
            if (!busy) {
                Runnable r = () -> this.showProgressPanel(false);
                SwingUtilities.invokeLater(r);
            }
        });
    }

    private void createProgressPanel() {
        this.cardLayout = new CardLayout();
        this.progressPanel = new JPanel(this.cardLayout);
        if (this.defaultComponent == null) {
            this.progressPanel.setVisible(false);
        } else {
            this.progressPanel.add(this.defaultComponent, DEFAULT);
        }
        this.monitor = new TaskMonitorComponent();
        this.progressPanel.add((Component)this.monitor, PROGRESS);
    }

    private void showProgressPanel(boolean showProgress) {
        if (this.defaultComponent == null) {
            this.progressPanel.setVisible(showProgress);
        } else {
            this.cardLayout.show(this.progressPanel, showProgress ? PROGRESS : DEFAULT);
        }
    }

    private void cancelRunnables() {
        this.worker.clearAllJobsWithInterrupt_IKnowTheRisks();
    }

    public JComponent getMonitorComponent() {
        return this.progressPanel;
    }

    public void dispose() {
        this.worker.dispose();
    }

    public void cancelAllRunnables() {
        this.worker.clearAllJobs();
    }

    public void waitForNotBusy(int maxWaitMillis) {
        this.worker.waitUntilNoJobsScheduled(maxWaitMillis);
    }

    public void runNow(MonitoredRunnable runnable, String taskName) {
        this.runNow(runnable, this.runManagerName, 500);
    }

    public void runNow(MonitoredRunnable runnable, String taskName, int showProgressDelay) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable cannot be null!");
        }
        this.cancelRunnables();
        this.worker.schedule((Job)new RunnerJob(this, taskName, runnable, showProgressDelay));
    }

    public void runNext(MonitoredRunnable runnable, String taskName) {
        this.runNext(runnable, taskName, 500);
    }

    public void runNext(MonitoredRunnable runnable, String taskName, int showProgressDelay) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable cannot be null!");
        }
        this.worker.clearPendingJobs();
        this.worker.schedule((Job)new RunnerJob(this, taskName, runnable, showProgressDelay));
    }

    public void runLater(MonitoredRunnable runnable, String taskName, int showProgressDelay) {
        if (runnable == null) {
            throw new IllegalArgumentException("Runnable cannot be null!");
        }
        this.worker.schedule((Job)new RunnerJob(this, taskName, runnable, showProgressDelay));
    }

    public boolean isInProgress() {
        return this.worker.isBusy();
    }

    public void showCancelButton(boolean showCancel) {
        this.monitor.setCancelButtonVisibility(showCancel);
    }

    public void showProgressBar(boolean showProgress) {
        this.monitor.showProgress(showProgress);
    }

    public void showProgressIcon(boolean showIcon) {
        this.monitor.showProgressIcon(showIcon);
    }

    private void notifyTaskCompleted(MonitoredRunnable monitoredRunnable) {
        if (this.taskListener == null) {
            return;
        }
        Runnable runnable = () -> this.taskListener.taskCompleted(null);
        SwingUtilities.invokeLater(runnable);
    }

    private void notifyTaskCancelled(MonitoredRunnable monitoredRunnable) {
        if (this.taskListener == null) {
            return;
        }
        Runnable runnable = () -> this.taskListener.taskCancelled(null);
        SwingUtilities.invokeLater(runnable);
    }

    private static class RunnerJob
    extends Job {
        private volatile boolean progressDone;
        private final RunManager runManager;
        private final MonitoredRunnable runnable;
        private final String name;
        private Timer showTimer;
        private final int delay;

        RunnerJob(RunManager runManager, String taskName, MonitoredRunnable runnable, int delay) {
            this.runManager = runManager;
            this.name = taskName;
            this.runnable = runnable;
            this.delay = delay;
        }

        public void run(TaskMonitor monitor) {
            try {
                this.doExecute(monitor);
            }
            catch (Exception e) {
                this.progressDone = true;
                Msg.error((Object)((Object)this), (Object)("Unexpected error processing runnable: " + this.name), (Throwable)e);
            }
            finally {
                if (monitor.isCancelled()) {
                    this.runManager.notifyTaskCancelled(this.runnable);
                } else {
                    this.runManager.notifyTaskCompleted(this.runnable);
                }
            }
        }

        private void doExecute(TaskMonitor monitor) {
            this.trace("execute() - initialize monitor");
            this.initializeMonitor(monitor);
            this.trace("showProgress()");
            this.showProgress();
            this.trace("running runnable");
            this.runnable.monitoredRun(monitor);
            this.trace("progress = true");
            this.progressDone = true;
            this.trace("calling SwingRunnable callback");
            SystemUtilities.runSwingNow((Runnable)new SwingRunner(monitor.isCancelled()));
            this.trace("completed = true");
            this.trace("exiting");
        }

        private void initializeMonitor(TaskMonitor monitor) {
            String text = this.name == null ? "" : this.name;
            monitor.setMessage(text);
        }

        private void showProgress() {
            Runnable showProgressRunnable = () -> {
                this.trace("showProgress() invokeLater() posted");
                if (this.delay <= 0) {
                    this.runManager.showProgressPanel(true);
                } else {
                    this.showTimer = new Timer(this.delay, event -> {
                        if (!this.progressDone) {
                            this.runManager.showProgressPanel(true);
                            this.showTimer = null;
                        }
                    });
                    this.showTimer.setInitialDelay(this.delay);
                    this.showTimer.setRepeats(false);
                    this.showTimer.start();
                }
            };
            SwingUtilities.invokeLater(showProgressRunnable);
        }

        private void trace(String message) {
        }

        private class SwingRunner
        implements Runnable {
            private boolean wasCancelled;

            public SwingRunner(boolean cancelledWhileRunning) {
                boolean cancelledBeforeStarted = RunnerJob.this.isCancelled();
                this.wasCancelled = cancelledWhileRunning || cancelledBeforeStarted;
            }

            @Override
            public void run() {
                if (RunnerJob.this.runnable instanceof SwingRunnable) {
                    SwingRunnable swingRunnable = (SwingRunnable)RunnerJob.this.runnable;
                    try {
                        swingRunnable.swingRun(this.wasCancelled);
                    }
                    catch (Throwable t) {
                        Msg.error((Object)RunnerJob.this.runManager, (Object)"Unexpected Exception Running Job", (Throwable)t);
                    }
                }
            }
        }
    }
}

