/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;

public class ConstructorInfo {
    private int length;
    private int flowFlags;
    public static final int RETURN = 1;
    public static final int CALL_INDIRECT = 2;
    public static final int BRANCH_INDIRECT = 4;
    public static final int CALL = 8;
    public static final int JUMPOUT = 16;
    public static final int NO_FALLTHRU = 32;
    public static final int BRANCH_TO_END = 64;

    public ConstructorInfo(int ln, int fl) {
        this.length = ln;
        this.flowFlags = fl;
    }

    public int getFlowFlags() {
        return this.flowFlags;
    }

    public int getLength() {
        return this.length;
    }

    public void addLength(int l) {
        this.length += l;
    }

    FlowType getFlowType() {
        switch (this.flowFlags) {
            case 0: 
            case 64: {
                return RefType.FALL_THROUGH;
            }
            case 8: {
                return RefType.UNCONDITIONAL_CALL;
            }
            case 72: {
                return RefType.CONDITIONAL_CALL;
            }
            case 2: {
                return RefType.COMPUTED_CALL;
            }
            case 66: {
                return RefType.COMPUTED_CALL;
            }
            case 36: {
                return RefType.COMPUTED_JUMP;
            }
            case 100: {
                return RefType.FALL_THROUGH;
            }
            case 33: {
                return RefType.TERMINATOR;
            }
            case 97: {
                return RefType.CONDITIONAL_TERMINATOR;
            }
            case 16: {
                return RefType.CONDITIONAL_JUMP;
            }
            case 48: {
                return RefType.UNCONDITIONAL_JUMP;
            }
            case 112: {
                return RefType.CONDITIONAL_JUMP;
            }
            case 32: {
                return RefType.TERMINATOR;
            }
            case 80: {
                return RefType.CONDITIONAL_JUMP;
            }
            case 96: {
                return RefType.FALL_THROUGH;
            }
        }
        return RefType.INVALID;
    }
}

