/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.CharsetSettingsDefinition;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeEncodeException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeWithCharset;
import ghidra.program.model.data.RenderUnicodeSettingsDefinition;
import ghidra.program.model.data.SignedCharDataType;
import ghidra.program.model.data.TranslationSettingsDefinition;
import ghidra.program.model.data.UnsignedCharDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.StringFormat;
import ghidra.util.classfinder.ClassTranslator;

public class CharDataType
extends AbstractIntegerDataType
implements DataTypeWithCharset {
    private static SettingsDefinition[] CHAR_SETTINGS_DEFS;
    private static SettingsDefinition[] WIDE_UTF_CHAR_SETTINGS_DEFS;
    public static final CharDataType dataType;

    public CharDataType() {
        this(null);
    }

    public CharDataType(DataTypeManager dtm) {
        this("char", dtm);
    }

    protected CharDataType(String name, DataTypeManager dtm) {
        super(name, dtm);
    }

    @Override
    public boolean isSigned() {
        return this.getDataOrganization().isSignedChar();
    }

    @Override
    protected FormatSettingsDefinition getFormatSettingsDefinition() {
        return FormatSettingsDefinition.DEF_CHAR;
    }

    @Override
    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return this.isWideUTFChar() ? WIDE_UTF_CHAR_SETTINGS_DEFS : CHAR_SETTINGS_DEFS;
    }

    private boolean isWideUTFChar() {
        return this.getLength() != 1;
    }

    @Override
    public String getCDeclaration() {
        return this.name;
    }

    @Override
    public int getLength() {
        return this.getDataOrganization().getCharSize();
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Character";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        try {
            int size = this.getLength();
            if (size == 1) {
                return Character.valueOf((char)buf.getUnsignedByte(0));
            }
            int val = -1;
            if (size == 2) {
                val = buf.getShort(0);
            }
            if (size == 4) {
                val = buf.getInt(0);
            }
            if (val >= 0 && val <= 65535) {
                return Character.valueOf((char)val);
            }
            return null;
        }
        catch (MemoryAccessException e) {
            return null;
        }
    }

    @Override
    public boolean isEncodable() {
        return true;
    }

    @Override
    public byte[] encodeValue(Object value, MemBuffer buf, Settings settings, int length) throws DataTypeEncodeException {
        return this.encodeCharacterValue(value, buf, settings);
    }

    @Override
    public byte[] encodeRepresentation(String repr, MemBuffer buf, Settings settings, int length) throws DataTypeEncodeException {
        return this.encodeCharacterRepresentation(repr, buf, settings);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Character.class;
    }

    @Override
    public CharDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new CharDataType(dtm);
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int length, DataTypeDisplayOptions options) {
        StringBuilder strBuf = new StringBuilder(this.getDefaultLabelPrefix());
        strBuf.append("_");
        try {
            byte b = buf.getByte(0);
            if (b > 31 && b < 128) {
                strBuf.append((char)b);
            } else {
                strBuf.append(StringFormat.hexByteString((byte)b));
                strBuf.append('h');
            }
        }
        catch (MemoryAccessException e) {
            strBuf.append("??");
        }
        return strBuf.toString();
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "CHAR";
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return null;
    }

    @Override
    public CharDataType getOppositeSignednessDataType() {
        return this.isSigned() ? UnsignedCharDataType.dataType.clone(this.getDataTypeManager()) : SignedCharDataType.dataType.clone(this.getDataTypeManager());
    }

    @Override
    public String getCharsetName(Settings settings) {
        switch (this.getLength()) {
            case 1: {
                return CharsetSettingsDefinition.CHARSET.getCharset(settings, "US-ASCII");
            }
            case 2: {
                return "UTF-16";
            }
            case 4: {
                return "UTF-32";
            }
        }
        return "US-ASCII";
    }

    static {
        ClassTranslator.put((String)"ghidra.program.model.data.AsciiDataType", (String)CharDataType.class.getName());
        CHAR_SETTINGS_DEFS = new SettingsDefinition[]{FormatSettingsDefinition.DEF_CHAR, PADDING, ENDIAN, MNEMONIC, CharsetSettingsDefinition.CHARSET, RenderUnicodeSettingsDefinition.RENDER, TranslationSettingsDefinition.TRANSLATION};
        WIDE_UTF_CHAR_SETTINGS_DEFS = new SettingsDefinition[]{FormatSettingsDefinition.DEF_CHAR, PADDING, ENDIAN, MNEMONIC, RenderUnicodeSettingsDefinition.RENDER, TranslationSettingsDefinition.TRANSLATION};
        dataType = new CharDataType();
    }
}

