/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledUnknown;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftProtocolNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        String name = null;
        Demangled namespace = null;
        block4: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case Identifier: {
                    name = child.getText();
                    continue block4;
                }
                case Module: {
                    namespace = child.demangle(demangler);
                    continue block4;
                }
            }
            this.skip(child);
        }
        if (name == null) {
            return this.getUnknown();
        }
        DemangledUnknown demangled = new DemangledUnknown(this.properties.mangled(), this.properties.originalDemangled(), name);
        demangled.setNamespace(namespace);
        return demangled;
    }
}

