/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.validator;

import docking.widgets.conditiontestpanel.ConditionResult;
import docking.widgets.conditiontestpanel.ConditionStatus;
import ghidra.app.plugin.core.analysis.validator.PostAnalysisValidator;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.validator.VTPreconditionValidator;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorSplitter;

public abstract class VTPostAnalysisPreconditionValidatorAdaptor
extends VTPreconditionValidator {
    private final PostAnalysisValidator sourceValidator;
    private final PostAnalysisValidator destinationValidator;

    public VTPostAnalysisPreconditionValidatorAdaptor(Program sourceProgram, Program destinationProgram, VTSession existingResults) {
        super(sourceProgram, destinationProgram, existingResults);
        this.sourceValidator = this.createPostAnalysisPreconditionValidator(sourceProgram);
        this.destinationValidator = this.createPostAnalysisPreconditionValidator(destinationProgram);
    }

    protected abstract PostAnalysisValidator createPostAnalysisPreconditionValidator(Program var1);

    public String getDescription() {
        return this.sourceValidator.getDescription();
    }

    public String getName() {
        return this.sourceValidator.getName();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public ConditionResult doRun(TaskMonitor monitor) throws CancelledException {
        TaskMonitor[] subMonitors = TaskMonitorSplitter.splitTaskMonitor((TaskMonitor)monitor, (int)2);
        ConditionResult sourceResult = this.sourceValidator.run(subMonitors[0]);
        ConditionResult destinationResult = this.destinationValidator.run(subMonitors[1]);
        ConditionResult result = this.combine(sourceResult, destinationResult);
        return result;
    }

    private ConditionResult combine(ConditionResult sourceResult, ConditionResult destinationResult) {
        ConditionStatus sourceStatus = sourceResult.getStatus();
        ConditionStatus destinationStatus = destinationResult.getStatus();
        String sourceMessage = sourceResult.getMessage();
        String destinationMessage = destinationResult.getMessage();
        ConditionStatus status = ConditionStatus.Passed;
        if (sourceStatus == destinationStatus) {
            status = sourceStatus;
        } else if (sourceStatus == ConditionStatus.Error || destinationStatus == ConditionStatus.Error) {
            status = ConditionStatus.Error;
        } else if (sourceStatus == ConditionStatus.Warning || destinationStatus == ConditionStatus.Warning) {
            status = ConditionStatus.Warning;
        } else if (sourceStatus == ConditionStatus.Skipped || destinationStatus == ConditionStatus.Skipped) {
            status = ConditionStatus.Skipped;
        } else if (sourceStatus == ConditionStatus.Cancelled || destinationStatus == ConditionStatus.Cancelled) {
            status = ConditionStatus.Cancelled;
        } else if (sourceStatus == ConditionStatus.None || destinationStatus == ConditionStatus.None) {
            status = ConditionStatus.None;
        }
        return new ConditionResult(status, this.combine(sourceMessage, destinationMessage));
    }

    private String combine(String sourceMessage, String destinationMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sourceValidator.getProgram().getName());
        sb.append(":\n");
        sb.append(sourceMessage);
        sb.append("\n");
        sb.append(this.destinationValidator.getProgram().getName());
        sb.append(":\n");
        sb.append(destinationMessage);
        return sb.toString();
    }
}

