# frozen_string_literal: true

class IdxVulnerabilityStatisticsOnTraversalIdsAndLetterGrade < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!
  milestone '17.9'

  INDEX_NAME = 'idx_vulnerability_statistics_on_traversal_ids_and_letter_grade'

  def up
    add_concurrent_index :vulnerability_statistics, %i[traversal_ids letter_grade], name: INDEX_NAME,
      where: 'archived = FALSE'
  end

  def down
    remove_concurrent_index_by_name :vulnerability_statistics, INDEX_NAME
  end
end
