---
stage: Create
group: Editor Extensions
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Visual StudioでGitLab Duoに接続して使用します。
title: Visual Studio用のGitLab拡張機能
---

[GitLab拡張機能](https://marketplace.visualstudio.com/items?itemName=GitLab.GitLabExtensionForVisualStudio)は、GitLabとWindows版Visual Studioを統合します。GitLab for Visual Studioは、[GitLab Duoコード提案](../../user/project/repository/code_suggestions/_index.md)と[GitLab Duo Chat](../../user/gitlab_duo_chat/_index.md#use-gitlab-duo-chat-in-visual-studio-for-windows)をサポートしています。

[拡張機能をインストールして設定します](setup.md)。

[`gitlab-visual-studio-extension`イシュートラッカー](https://gitlab.com/gitlab-org/editor-extensions/gitlab-visual-studio-extension/-/issues)で、イシュー、バグ、または機能リクエストを報告してください。

## 拡張機能を更新する {#update-the-extension}

拡張機能を最新バージョンに更新するには、次の手順に従います。

1. Visual Studioで、**Extensions > Manage Extensions...**（拡張機能 > 拡張機能の管理...）に移動します。
1. **Updates**（更新）タブを選択します。
1. **GitLab（`gitlab.com`）**が発行した**GitLab**を検索します。
1. 拡張機能の**Update**（更新）を選択して、最新バージョンに更新します。

## 関連トピック {#related-topics}

- [このプラグインに関するオープンイシュー](https://gitlab.com/gitlab-org/editor-extensions/gitlab-visual-studio-extension/-/issues/)
- [ソースコードを表示する](https://gitlab.com/gitlab-org/editor-extensions/gitlab-visual-studio-extension)
- [GitLab言語サーバーのドキュメント](../language_server/_index.md)

## トラブルシューティング {#troubleshooting}

トラブルシューティングの情報については、[拡張機能のトラブルシューティングページ](visual_studio_troubleshooting.md)を参照してください。
