---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Server-side code injection (Ruby)
---

## Description

The target application was found vulnerable to code injection. A malicious actor could inject arbitrary
Ruby code to be executed on the server. This could lead to a full system compromise by accessing
stored secrets, injecting code to take over accounts, or executing OS commands.

## Remediation

Never pass user input directly into functions which evaluate string data as code, such as `eval`,
`send`, `public_send`, `instance_eval` or `class_eval`. There is almost no benefit of passing string
values to these methods, as such the best recommendation is to replace the current logic with more safe
implementations of dynamically evaluating logic with user input. If using `send` or `public_send` ensure
the first argument is to a known, hardcoded method/symbol and does not come from user input.

For `eval`, `instance_eval` and `class_eval`, user input should never be sent directly to these methods.
One alternative is to store functions or methods in a Hash that can be looked up using a key. If the key
exists, the function can be executed.

```ruby
def func_to_run
  puts 'hello world'
end

input = 'fn'

function_map = { fn: method(:func_to_run) }

if function_map.key?(input.to_sym)
  function_map[input.to_sym].call
else
  puts 'invalid input'
end
```

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 94.2 | false | 94 | Active | high |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/94.html)
