/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.Command;
import tim.prune.cmd.ConnectMultipleMediaCmd;
import tim.prune.cmd.EditSingleFieldCmd;
import tim.prune.cmd.MediaLinkType;
import tim.prune.cmd.PointAndMedia;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.Track;
import tim.prune.function.FieldListModel;
import tim.prune.function.edit.PointEdit;

public class DeleteFieldValues
extends GenericFunction {
    private JDialog _dialog = null;
    private JList<String> _fieldList = null;
    private FieldListModel _listModel = null;
    private JButton _okButton = null;

    public DeleteFieldValues(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.deletefieldvalues";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.initDialog();
        if (this._listModel.getSize() < 1) {
            this._app.showErrorMessage(this.getNameKey(), "dialog.deletefieldvalues.nofields");
        } else {
            this._dialog.setVisible(true);
        }
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.deletefieldvalues.intro")), "North");
        this._fieldList = new JList<String>(new String[]{"First field", "Second field"});
        this._fieldList.setSelectionMode(0);
        this._fieldList.addListSelectionListener(listSelectionEvent -> this._okButton.setEnabled(this._fieldList.getSelectedIndex() >= 0));
        jPanel.add((Component)new JScrollPane(this._fieldList), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(actionEvent -> this.finish());
        this._okButton.setEnabled(false);
        jPanel2.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void initDialog() {
        this._listModel = new FieldListModel();
        int n = this._app.getTrackInfo().getSelection().getStart();
        int n2 = this._app.getTrackInfo().getSelection().getEnd();
        Track track = this._app.getTrackInfo().getTrack();
        FieldList fieldList = track.getFieldList();
        int n3 = 0;
        while (n3 < fieldList.getNumFields()) {
            Field field = fieldList.getField(n3);
            if (field != Field.LATITUDE && field != Field.LONGITUDE && track.hasData(field, n, n2)) {
                this._listModel.addField(field);
            }
            ++n3;
        }
        if (track.hasData(Field.PHOTO, n, n2)) {
            this._listModel.addField(Field.PHOTO);
        }
        if (track.hasData(Field.AUDIO, n, n2)) {
            this._listModel.addField(Field.AUDIO);
        }
        this._fieldList.setModel(this._listModel);
        this._fieldList.clearSelection();
        this._okButton.setEnabled(false);
    }

    private void finish() {
        Field field = this._listModel.getField(this._fieldList.getSelectedIndex());
        if (field == null) {
            return;
        }
        int n = this._app.getTrackInfo().getSelection().getStart();
        int n2 = this._app.getTrackInfo().getSelection().getEnd();
        this._dialog.dispose();
        Command command = this.makeCommand(field, n, n2);
        command.setDescription(I18nManager.getText("undo.deletefieldvalues", field.getName()));
        command.setConfirmText(I18nManager.getText("confirm.deletefieldvalues"));
        this._app.execute(command);
    }

    private Command makeCommand(Field field, int n, int n2) {
        if (field == Field.PHOTO || field == Field.AUDIO) {
            MediaLinkType mediaLinkType = field == Field.PHOTO ? MediaLinkType.LINK_PHOTOS : MediaLinkType.LINK_AUDIOS;
            ArrayList<PointAndMedia> arrayList = new ArrayList<PointAndMedia>();
            Track track = this._app.getTrackInfo().getTrack();
            int n3 = n;
            while (n3 <= n2) {
                arrayList.add(new PointAndMedia(track.getPoint(n3), null));
                ++n3;
            }
            return new ConnectMultipleMediaCmd(mediaLinkType, arrayList);
        }
        ArrayList<PointEdit> arrayList = new ArrayList<PointEdit>();
        int n4 = n;
        while (n4 <= n2) {
            arrayList.add(new PointEdit(n4, null));
            ++n4;
        }
        return new EditSingleFieldCmd(field, arrayList, this.getConfig().getUnitSet());
    }
}

