/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.data;

import java.util.Collection;
import java.util.HashSet;
import java.util.TimeZone;
import tim.prune.data.Timestamp;
import tim.prune.data.TimestampUtc;
import tim.prune.function.filesleuth.data.Date;
import tim.prune.function.filesleuth.data.DateRange;
import tim.prune.function.filesleuth.data.LocationFilter;
import tim.prune.function.filesleuth.data.TrackBounds;

public class TrackContents {
    private String _nameOrDesc = "";
    private HashSet<String> _strings = null;
    private final TimeZone _timezone;
    private Date _dateFrom = null;
    private Date _dateTo = null;
    private final TrackBounds _trackBounds = new TrackBounds();

    public TrackContents(TimeZone timeZone) {
        this._timezone = timeZone;
    }

    public void setName(String string) {
        this._nameOrDesc = this.trimString(string);
    }

    public void setDescription(String string) {
        if (this._nameOrDesc.isEmpty()) {
            this._nameOrDesc = this.trimString(string);
        }
    }

    public String getNameOrDescription() {
        return this._nameOrDesc;
    }

    private String trimString(String string) {
        return string == null ? "" : string.trim();
    }

    public void addString(String string) {
        if (string == null) {
            return;
        }
        String string2 = string.trim();
        if (string2.equals("")) {
            return;
        }
        if (this._strings == null) {
            this._strings = new HashSet();
        }
        this._strings.add(string2.toLowerCase());
    }

    public int getNumStrings() {
        return this._strings == null ? 0 : this._strings.size();
    }

    public Collection<String> getStrings() {
        return this._strings;
    }

    public void addDateString(String string) {
        Date date;
        if (string == null || string.equals("")) {
            return;
        }
        TimestampUtc timestampUtc = new TimestampUtc(string);
        if (((Timestamp)timestampUtc).isValid() && (date = Date.parseString(timestampUtc.getIsoDateString(this._timezone))) != null) {
            if (this._dateFrom == null || this._dateFrom.isAfter(date)) {
                this._dateFrom = date;
            }
            if (date.isAfter(this._dateTo)) {
                this._dateTo = date;
            }
        }
    }

    public DateRange getDateRange() {
        return new DateRange(this._dateFrom, this._dateTo);
    }

    public boolean matchesDateFilter(DateRange dateRange) {
        return dateRange.overlaps(this.getDateRange());
    }

    public void addCoordinates(double d, double d2) {
        this._trackBounds.addCoordinates(d, d2);
    }

    public boolean matchesLocationFilter(LocationFilter locationFilter) {
        return locationFilter == null || locationFilter.getPoint() == null || this._trackBounds.overlaps(locationFilter);
    }
}

