/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map.tile;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import tim.prune.gui.map.CacheFailure;
import tim.prune.gui.map.MapTile;
import tim.prune.gui.map.tile.TileBytes;
import tim.prune.gui.map.tile.TileDef;

public class DiskCache {
    private String _basePath = null;
    private boolean _triedToCreateBasePath = false;
    private static final long CACHE_TIME_LIMIT = 1728000000L;

    public void setBasePath(String string) {
        this._basePath = string;
    }

    public MapTile getTile(TileDef tileDef) {
        String string = tileDef.getFilePath();
        if (this._basePath == null || string == null) {
            return null;
        }
        File file = new File(this._basePath, string);
        if (file.exists() && file.canRead() && file.length() > 0L) {
            long l = file.lastModified();
            boolean bl = System.currentTimeMillis() - l > 1728000000L;
            try {
                Image image = Toolkit.getDefaultToolkit().createImage(file.getAbsolutePath());
                image.getWidth(null);
                return new MapTile(image, bl);
            }
            catch (Exception exception) {
                System.err.println("error creating image: " + exception.getClass().getName() + ": " + exception.getMessage());
            }
        }
        return null;
    }

    public void saveTileBytes(TileBytes tileBytes, TileDef tileDef) throws CacheFailure {
        if (this._basePath == null) {
            return;
        }
        File file = new File(this._basePath, tileDef.getFilePath());
        if (this.directoryOk(file)) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    fileOutputStream.write(tileBytes.getData());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                System.out.println("Failed to write to: " + tileDef.getFilePath());
                iOException.printStackTrace();
                throw new CacheFailure();
            }
        }
    }

    private boolean directoryOk(File file) throws CacheFailure {
        if (!this.checkBasePath()) {
            throw new CacheFailure();
        }
        File file2 = file.getParentFile();
        return (file2.exists() || file2.mkdirs()) && file2.canWrite();
    }

    public void saveTileImage(RenderedImage renderedImage, TileDef tileDef) throws CacheFailure {
        if (this._basePath == null) {
            return;
        }
        if (!tileDef._mapSource.getFileExtension(tileDef._layerIdx).equals("png")) {
            return;
        }
        File file = new File(this._basePath, tileDef.getFilePath());
        if (this.directoryOk(file)) {
            try {
                if (!ImageIO.write(renderedImage, "png", file)) {
                    System.err.println("Failed to write file: " + file.getAbsolutePath());
                    throw new CacheFailure();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new CacheFailure();
            }
        }
    }

    private boolean checkBasePath() {
        File file = new File(this._basePath);
        if (!file.exists() && !this._triedToCreateBasePath) {
            this._triedToCreateBasePath = true;
            System.out.println("Base path '" + file.getAbsolutePath() + "' does not exist, trying to create");
            return file.mkdirs();
        }
        return file.exists() && file.isDirectory() && file.canWrite();
    }
}

