#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dependent-sum
version:              0.7.2.0
visibility:           public
id:                   dependent-sum-0.7.2.0-4eKGxOfs6EAG6eZbQGdemS
key:                  dependent-sum-0.7.2.0-4eKGxOfs6EAG6eZbQGdemS
license:              LicenseRef-PublicDomain
maintainer:           Obsidian Systems, LLC <maintainer@obsidian.systems>
author:               James Cook <mokus@deepbondi.net>
stability:            provisional
homepage:             https://github.com/obsidiansystems/dependent-sum
synopsis:             Dependent sum type
description:
    A dependent sum is a generalization of a
    particular way of thinking about the @Either@
    type.  @Either a b@ can be thought of as a
    2-tuple @(tag, value)@, where the value of the
    tag determines the type of the value.  In
    particular, either @tag = Left@ and @value :: a@
    or @tag = Right@ and @value :: b@.

    This package allows you to define your own
    dependent sum types by using your own \"tag\"
    types.

category:             Data, Dependent Types
abi:                  ae8f972d49da8663cc2c1183bf271bc9
exposed:              True
exposed-modules:
    Data.Dependent.Sum,
    Data.GADT.Compare from some-1.0.6-5quJMhXfx6a6XD1YK9AlIB:Data.GADT.Compare,
    Data.GADT.Show from some-1.0.6-5quJMhXfx6a6XD1YK9AlIB:Data.GADT.Show,
    Data.Some from some-1.0.6-5quJMhXfx6a6XD1YK9AlIB:Data.Some

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dependent-sum-0.7.2.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dependent-sum-0.7.2.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dependent-sum-0.7.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-dependent-sum
hs-libraries:         HSdependent-sum-0.7.2.0-4eKGxOfs6EAG6eZbQGdemS
depends:
    base-4.17.2.1 constraints-extras-0.4.0.2-6A0be6YeTwE4lqN1S81os6
    some-1.0.6-5quJMhXfx6a6XD1YK9AlIB

haddock-interfaces:
    /usr/share/doc/haskell-dependent-sum/html/dependent-sum.haddock

haddock-html:         /usr/share/doc/haskell-dependent-sum/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

