#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 incremental-parser
version:              0.5.1
visibility:           public
id:                   incremental-parser-0.5.1-7j9TSJCPqzU4Z73mxPiAIh
key:                  incremental-parser-0.5.1-7j9TSJCPqzU4Z73mxPiAIh
license:              GPL-3.0-only
copyright:            (c) 2011-2023 Mario Blazevic
maintainer:           blamario@yahoo.com
author:               Mario Blazevic
homepage:             https://github.com/blamario/incremental-parser
synopsis:
    Generic parser library capable of providing partial results from partial input.

description:
    This package defines yet another parser combinator library. This one is implemented using the concept of Brzozowski
    derivatives, tweaked and optimized to work with any monoidal input type. Lists, ByteString, and Text are supported out
    of the box, as well as any other data type for which the monoid-subclasses package defines instances. If the parser
    result is also a monoid, its chunks can be extracted incrementally, before the complete input is parsed.

category:             Parsing
abi:                  9a70aa5979c8d97fb0eca02fdc98e901
exposed:              True
exposed-modules:
    Control.Applicative.Monoid Text.ParserCombinators.Incremental
    Text.ParserCombinators.Incremental.LeftBiasedLocal
    Text.ParserCombinators.Incremental.Symmetric

import-dirs:          /usr/lib/ghc-9.6.6/site-local/incremental-parser-0.5.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/incremental-parser-0.5.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/incremental-parser-0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-incremental-parser
hs-libraries:         HSincremental-parser-0.5.1-7j9TSJCPqzU4Z73mxPiAIh
depends:
    base-4.18.2.1 input-parsers-0.3.0.2-501Zre3EdWNJIPLNm8QaBu
    logict-0.8.2.0-4RAsYK5gbAjChAERSRMSYV
    monoid-subclasses-1.2.6-4KJjfc7UL9dHeREgaFFa23
    parsers-0.12.12-3ctdS7BplAaRKS9RF5B8
    rank2classes-1.5.5-1pjJq6nwd5O8KJcFOebSGh transformers-0.6.1.0

haddock-interfaces:
    /usr/share/doc/haskell-incremental-parser/html/incremental-parser.haddock

haddock-html:         /usr/share/doc/haskell-incremental-parser/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

