/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationCache;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class RootsCalculator {
    private static final Logger LOG = Logger.getInstance(RootsCalculator.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final AbstractVcs myVcs;
    @NotNull
    private final ProjectLevelVcsManager myPlManager;
    @NotNull
    private final RepositoryLocationCache myLocationCache;

    public RootsCalculator(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull RepositoryLocationCache locationCache) {
        if (project == null) {
            RootsCalculator.$$$reportNull$$$0(0);
        }
        if (vcs == null) {
            RootsCalculator.$$$reportNull$$$0(1);
        }
        if (locationCache == null) {
            RootsCalculator.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myLocationCache = locationCache;
        this.myPlManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myVcs = vcs;
    }

    @NotNull
    public Map<VirtualFile, RepositoryLocation> getRoots() {
        LOG.debug("Collecting roots for " + String.valueOf(this.myVcs));
        List<VirtualFile> roots = this.getRootsFromMappings();
        ContainerUtil.addAll(roots, (Object[])this.myPlManager.getRootsUnderVcs(this.myVcs));
        RootsCalculator.logRoots("Candidates", roots);
        roots.removeIf(file -> this.getLocation((VirtualFile)file) == null);
        RootsCalculator.logRoots("Candidates with repository location", roots);
        Map result2 = ((StreamEx)StreamEx.of((Collection)this.myVcs.filterUniqueRoots(roots, Function.identity())).distinct()).mapToEntry(this::getLocation).nonNullValues().toMap();
        RootsCalculator.logRoots("Unique roots", result2.keySet());
        Map map = result2;
        if (map == null) {
            RootsCalculator.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    private List<VirtualFile> getRootsFromMappings() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VcsDirectoryMapping mapping : this.myPlManager.getDirectoryMappings(this.myVcs)) {
            if (mapping.isDefaultMapping()) {
                if (!this.myVcs.equals((Object)this.myPlManager.getVcsFor(this.myProject.getBaseDir()))) continue;
                result2.add(this.myProject.getBaseDir());
                continue;
            }
            VirtualFile newFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(mapping.getDirectory());
            if (newFile != null) {
                result2.add(newFile);
                continue;
            }
            LOG.info("Can not find virtual file for root: " + mapping.getDirectory());
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            RootsCalculator.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    private RepositoryLocation getLocation(@NotNull VirtualFile file) {
        if (file == null) {
            RootsCalculator.$$$reportNull$$$0(5);
        }
        return this.myLocationCache.getLocation(this.myVcs, VcsUtil.getFilePath((VirtualFile)file), false);
    }

    private static void logRoots(@NonNls @NotNull String prefix, @NotNull Collection<? extends VirtualFile> roots) {
        if (prefix == null) {
            RootsCalculator.$$$reportNull$$$0(6);
        }
        if (roots == null) {
            RootsCalculator.$$$reportNull$$$0(7);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(prefix + ": " + StringUtil.join(roots, VirtualFile::getPath, (String)", "));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/RootsCalculator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/RootsCalculator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsFromMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "logRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

