/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.model;

import java.io.File;

public final class AffectedModule {
    private final String type;
    private final String name;
    private final long hash;
    private final File outPath;

    public AffectedModule(String type, String name, long hash, File outPath) {
        this.type = type;
        this.name = name;
        this.hash = hash;
        this.outPath = outPath;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public long getHash() {
        return this.hash;
    }

    public File getOutPath() {
        return this.outPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AffectedModule module = (AffectedModule)o;
        if (this.type != null ? !this.type.equals(module.type) : module.type != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(module.name) : module.name != null) {
            return false;
        }
        if (this.hash != module.hash) {
            return false;
        }
        return !(this.outPath != null ? !this.outPath.equals(module.outPath) : module.outPath != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + Long.hashCode(this.hash);
        result = 31 * result + (this.outPath != null ? this.outPath.hashCode() : 0);
        return result;
    }
}

