/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u001a\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0010\u001a\u00020\u0001*\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013\u00a8\u0006\u0014"}, d2={"isInvoke", "", "Lorg/jetbrains/kotlin/name/CallableId;", "isFunctionOrSuspendFunctionInvoke", "isSuspendFunctionInvoke", "isKSuspendFunctionInvoke", "isFunctionInvoke", "isKFunctionInvoke", "isIteratorNext", "isIteratorHasNext", "isIterator", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isRealOwnerOf", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeLookupTag;", "declarationSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "semantics"})
@SourceDebugExtension(value={"SMAP\nCallableIdUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallableIdUtils.kt\norg/jetbrains/kotlin/fir/resolve/CallableIdUtilsKt\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,64:1\n28#2:65\n*S KotlinDebug\n*F\n+ 1 CallableIdUtils.kt\norg/jetbrains/kotlin/fir/resolve/CallableIdUtilsKt\n*L\n58#1:65\n*E\n"})
public final class CallableIdUtilsKt {
    public static final boolean isInvoke(@NotNull CallableId $this$isInvoke) {
        Intrinsics.checkNotNullParameter($this$isInvoke, "<this>");
        return CallableIdUtilsKt.isFunctionInvoke($this$isInvoke) || CallableIdUtilsKt.isKFunctionInvoke($this$isInvoke);
    }

    public static final boolean isFunctionOrSuspendFunctionInvoke(@NotNull CallableId $this$isFunctionOrSuspendFunctionInvoke) {
        Intrinsics.checkNotNullParameter($this$isFunctionOrSuspendFunctionInvoke, "<this>");
        return CallableIdUtilsKt.isFunctionInvoke($this$isFunctionOrSuspendFunctionInvoke) || CallableIdUtilsKt.isSuspendFunctionInvoke($this$isFunctionOrSuspendFunctionInvoke);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSuspendFunctionInvoke(@NotNull CallableId $this$isSuspendFunctionInvoke) {
        Intrinsics.checkNotNullParameter($this$isSuspendFunctionInvoke, "<this>");
        if (!Intrinsics.areEqual($this$isSuspendFunctionInvoke.getCallableName().asString(), "invoke")) return false;
        FqName fqName = $this$isSuspendFunctionInvoke.getClassName();
        Object object = fqName;
        if (fqName == null) return false;
        String string = ((FqName)object).asString();
        object = string;
        if (string == null) return false;
        if (!StringsKt.startsWith$default((String)object, "SuspendFunction", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isSuspendFunctionInvoke.getPackageName(), StandardClassIds.INSTANCE.getBASE_COROUTINES_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKSuspendFunctionInvoke(@NotNull CallableId $this$isKSuspendFunctionInvoke) {
        Intrinsics.checkNotNullParameter($this$isKSuspendFunctionInvoke, "<this>");
        if (!Intrinsics.areEqual($this$isKSuspendFunctionInvoke.getCallableName().asString(), "invoke")) return false;
        FqName fqName = $this$isKSuspendFunctionInvoke.getClassName();
        Object object = fqName;
        if (fqName == null) return false;
        String string = ((FqName)object).asString();
        object = string;
        if (string == null) return false;
        if (!StringsKt.startsWith$default((String)object, "KSuspendFunction", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isKSuspendFunctionInvoke.getPackageName(), StandardClassIds.INSTANCE.getBASE_REFLECT_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFunctionInvoke(@NotNull CallableId $this$isFunctionInvoke) {
        Intrinsics.checkNotNullParameter($this$isFunctionInvoke, "<this>");
        if (!Intrinsics.areEqual($this$isFunctionInvoke.getCallableName().asString(), "invoke")) return false;
        FqName fqName = $this$isFunctionInvoke.getClassName();
        Object object = fqName;
        if (fqName == null) return false;
        String string = ((FqName)object).asString();
        object = string;
        if (string == null) return false;
        if (!StringsKt.startsWith$default((String)object, "Function", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isFunctionInvoke.getPackageName(), StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKFunctionInvoke(@NotNull CallableId $this$isKFunctionInvoke) {
        Intrinsics.checkNotNullParameter($this$isKFunctionInvoke, "<this>");
        if (!Intrinsics.areEqual($this$isKFunctionInvoke.getCallableName().asString(), "invoke")) return false;
        FqName fqName = $this$isKFunctionInvoke.getClassName();
        Object object = fqName;
        if (fqName == null) return false;
        String string = ((FqName)object).asString();
        object = string;
        if (string == null) return false;
        if (!StringsKt.startsWith$default((String)object, "KFunction", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isKFunctionInvoke.getPackageName(), StandardClassIds.INSTANCE.getBASE_REFLECT_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorNext(@NotNull CallableId $this$isIteratorNext) {
        Intrinsics.checkNotNullParameter($this$isIteratorNext, "<this>");
        if (!Intrinsics.areEqual($this$isIteratorNext.getCallableName().asString(), "next")) return false;
        FqName fqName = $this$isIteratorNext.getClassName();
        Object object = fqName;
        if (fqName == null) return false;
        String string = ((FqName)object).asString();
        object = string;
        if (string == null) return false;
        if (!StringsKt.endsWith$default((String)object, "Iterator", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isIteratorNext.getPackageName(), StandardClassIds.INSTANCE.getBASE_COLLECTIONS_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorHasNext(@NotNull CallableId $this$isIteratorHasNext) {
        Intrinsics.checkNotNullParameter($this$isIteratorHasNext, "<this>");
        if (!Intrinsics.areEqual($this$isIteratorHasNext.getCallableName().asString(), "hasNext")) return false;
        FqName fqName = $this$isIteratorHasNext.getClassName();
        Object object = fqName;
        if (fqName == null) return false;
        String string = ((FqName)object).asString();
        object = string;
        if (string == null) return false;
        if (!StringsKt.endsWith$default((String)object, "Iterator", false, 2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual($this$isIteratorHasNext.getPackageName(), StandardClassIds.INSTANCE.getBASE_COLLECTIONS_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIterator(@NotNull CallableId $this$isIterator) {
        Intrinsics.checkNotNullParameter($this$isIterator, "<this>");
        if (!Intrinsics.areEqual($this$isIterator.getCallableName().asString(), "iterator")) return false;
        String[] stringArray = new String[]{"kotlin", "kotlin.collections", "kotlin.ranges"};
        if (!ArraysKt.contains(stringArray, $this$isIterator.getPackageName().asString())) return false;
        return true;
    }

    @Nullable
    public static final FqName fqName(@NotNull FirAnnotation $this$fqName, @NotNull FirSession session) {
        Object object;
        Intrinsics.checkNotNullParameter($this$fqName, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        FirTypeRef $this$coneTypeSafe$iv = $this$fqName.getAnnotationTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
        if (!(coneKotlinType instanceof ConeSimpleKotlinType)) {
            coneKotlinType = null;
        }
        if ((object = (ConeSimpleKotlinType)((ConeKotlinType)((ConeSimpleKotlinType)coneKotlinType))) == null || (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeKotlinType)object, session)) == null) {
            return null;
        }
        Object symbol = object;
        return ((FirClassLikeSymbol)symbol).getClassId().asSingleFqName();
    }

    public static final boolean isRealOwnerOf(@NotNull ConeClassLikeLookupTag $this$isRealOwnerOf, @NotNull FirCallableSymbol<?> declarationSymbol) {
        Intrinsics.checkNotNullParameter($this$isRealOwnerOf, "<this>");
        Intrinsics.checkNotNullParameter(declarationSymbol, "declarationSymbol");
        return Intrinsics.areEqual($this$isRealOwnerOf, ClassMembersKt.dispatchReceiverClassLookupTagOrNull(declarationSymbol));
    }
}

