/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.EnumClassLoweringKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EnumClassConstructorLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "additionalParameters", "", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "transformFlat", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "transformEnumConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "enumConstructor", "enumClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nEnumClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/EnumClassConstructorLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,585:1\n315#2,4:586\n1563#3:590\n1634#3,3:591\n*S KotlinDebug\n*F\n+ 1 EnumClassLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/EnumClassConstructorLowering\n*L\n107#1:586,4\n112#1:590\n112#1:591,3\n*E\n"})
public final class EnumClassConstructorLowering
implements DeclarationTransformer {
    @NotNull
    private final JsCommonBackendContext context;
    @NotNull
    private final List<Pair<String, IrType>> additionalParameters;

    public EnumClassConstructorLowering(@NotNull JsCommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        Pair[] pairArray = new Pair[]{TuplesKt.to("name", this.context.getIrBuiltIns().getStringType()), TuplesKt.to("ordinal", this.context.getIrBuiltIns().getIntType())};
        this.additionalParameters = CollectionsKt.listOf(pairArray);
    }

    @NotNull
    public final JsCommonBackendContext getContext() {
        return this.context;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        block4: {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            IrDeclarationParent irDeclarationParent = declaration.getParent();
            IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
            if (irClass == null) break block4;
            IrClass irClass2 = irClass;
            boolean bl = false;
            if (!IrUtilsKt.isEnumClass(irClass2) || irClass2.isExpect() || IrUtilsKt.isEffectivelyExternal(irClass2)) {
                return null;
            }
            if (declaration instanceof IrConstructor) {
                return CollectionsKt.listOf(this.transformEnumConstructor((IrConstructor)declaration, irClass2));
            }
            if (declaration instanceof IrEnumEntry) {
                IrClass irClass3 = ((IrEnumEntry)declaration).getCorrespondingClass();
                if (irClass3 != null) {
                    IrClass klass = irClass3;
                    boolean bl2 = false;
                    JsIrAttributesKt.setCorrespondingEnumEntry(klass, (IrEnumEntry)declaration);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor transformEnumConstructor(IrConstructor enumConstructor, IrClass enumClass) {
        Object name2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrConstructor irConstructor;
        IrFactory $this$buildConstructor$iv = this.context.getIrFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2427$iv = new IrFunctionBuilder();
        boolean $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = false;
        IrFunctionBuilder $this$transformEnumConstructor_u24lambda_u242 = $this$buildConstructor_u24lambda_u2427$iv;
        boolean bl = false;
        $this$transformEnumConstructor_u24lambda_u242.updateFrom(enumConstructor);
        $this$transformEnumConstructor_u24lambda_u242.setReturnType(enumConstructor.getReturnType());
        IrConstructor $this$transformEnumConstructor_u24lambda_u248 = irConstructor = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u2427$iv);
        boolean bl2 = false;
        $this$transformEnumConstructor_u24lambda_u248.setParent(enumClass);
        Iterable $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv22 = this.additionalParameters;
        IrConstructor irConstructor2 = $this$transformEnumConstructor_u24lambda_u248;
        boolean $i$f$map = false;
        void var9_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            name2 = (String)pair.component1();
            IrType type = (IrType)pair.component2();
            collection.add(JsIrBuilder.buildValueParameter$default(JsIrBuilder.INSTANCE, $this$transformEnumConstructor_u24lambda_u248, (String)name2, type, false, null, null, 56, null));
        }
        irConstructor2.setParameters((List)destination$iv$iv);
        IrUtilsKt.copyValueAndTypeParametersFrom($this$transformEnumConstructor_u24lambda_u248, enumConstructor);
        IrConstructor newConstructor = $this$transformEnumConstructor_u24lambda_u248;
        JsIrAttributesKt.setNewEnumConstructor(enumConstructor, $this$transformEnumConstructor_u24lambda_u248);
        IrBody irBody = enumConstructor.getBody();
        if (irBody != null) {
            IrBody oldBody = irBody;
            boolean bl4 = false;
            $this$transformEnumConstructor_u24lambda_u248.setBody(IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), oldBody.getStartOffset(), oldBody.getEndOffset(), arg_0 -> EnumClassConstructorLowering.transformEnumConstructor$lambda$8$lambda$5$lambda$4(oldBody, this, enumClass, $this$transformEnumConstructor_u24lambda_u248, arg_0)));
        }
        for (IrValueParameter old : enumConstructor.getParameters()) {
            void $this$transformEnumConstructor_u24lambda_u248_u24lambda_u247_u24lambda_u246;
            IrExpressionBody irExpressionBody;
            IrValueParameter irValueParameter = $this$transformEnumConstructor_u24lambda_u248.getParameters().get(this.additionalParameters.size() + old.getIndexInParameters());
            JsIrAttributesKt.setValueParameterForOldEnumConstructor(old, irValueParameter);
            if (old.getDefaultValue() == null) continue;
            boolean bl5 = false;
            IrExpressionBody irExpressionBody2 = this.context.getIrFactory().createExpressionBody(irExpressionBody.getStartOffset(), irExpressionBody.getEndOffset(), irExpressionBody.getExpression());
            name2 = irExpressionBody2;
            IrValueParameter irValueParameter2 = irValueParameter;
            boolean bl6 = false;
            PatchDeclarationParentsKt.patchDeclarationParents((IrElement)$this$transformEnumConstructor_u24lambda_u248_u24lambda_u247_u24lambda_u246.getExpression(), newConstructor);
            EnumClassLoweringKt.access$fixReferencesToConstructorParameters(this.context, enumClass, (IrBody)$this$transformEnumConstructor_u24lambda_u248_u24lambda_u247_u24lambda_u246);
            irValueParameter2.setDefaultValue(irExpressionBody2);
        }
        return irConstructor;
    }

    private static final Unit transformEnumConstructor$lambda$8$lambda$5$lambda$4(IrBody $oldBody, EnumClassConstructorLowering this$0, IrClass $enumClass, IrConstructor $this_apply, IrBlockBody $this$createBlockBody) {
        Intrinsics.checkNotNullParameter($this$createBlockBody, "$this$createBlockBody");
        Collection collection = $this$createBlockBody.getStatements();
        Intrinsics.checkNotNull($oldBody, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
        CollectionsKt.addAll(collection, (Iterable)((IrBlockBody)$oldBody).getStatements());
        EnumClassLoweringKt.access$fixReferencesToConstructorParameters(this$0.context, $enumClass, $this$createBlockBody);
        PatchDeclarationParentsKt.patchDeclarationParents((IrElement)$this$createBlockBody, $enumClass);
        $this_apply.setBody($this$createBlockBody);
        return Unit.INSTANCE;
    }
}

