/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

import com.intellij.rt.coverage.data.ClassMetadata;
import com.intellij.rt.coverage.data.TestDiscoveryProjectData;
import com.intellij.rt.coverage.instrumentation.ExtraFieldInstrumenter;
import com.intellij.rt.coverage.testDiscovery.instrumentation.CheckSumCalculator;
import com.intellij.rt.coverage.testDiscovery.instrumentation.InstrumentedMethodsCollector;
import com.intellij.rt.coverage.testDiscovery.instrumentation.InstrumentedMethodsFilter;
import com.intellij.rt.coverage.testDiscovery.instrumentation.SourceFilesCollector;
import java.util.Collections;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class TestDiscoveryInstrumenter
extends ExtraFieldInstrumenter {
    private final String myClassName;
    int myClassVersion;
    private final InstrumentedMethodsFilter myMethodFilter;
    volatile boolean myInstrumentConstructors;
    private int myCurrentMethodCount;
    static final String METHODS_VISITED = "__$methodsVisited$__";
    static final String METHODS_VISITED_CLASS = "[Z";
    private final String[] myMethodNames;

    /*
     * WARNING - void declaration
     */
    public TestDiscoveryInstrumenter(ClassVisitor cw, ClassReader cr, String className) {
        super(cr, (ClassVisitor)var1_1, className, METHODS_VISITED, METHODS_VISITED_CLASS, false);
        void var2_2;
        void var3_3;
        void var1_1;
        this.myMethodFilter = new InstrumentedMethodsFilter(className);
        this.myClassName = var3_3;
        this.myMethodNames = this.inspectClass((ClassReader)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private String[] inspectClass(ClassReader cr) {
        void var2_2;
        void var3_3;
        void var1_1;
        CheckSumCalculator checksumCalculator = new CheckSumCalculator(this.api, this.myClassName);
        SourceFilesCollector sourceFilesCollector = new SourceFilesCollector(this.api, checksumCalculator, this.myClassName);
        TestDiscoveryInstrumenter testDiscoveryInstrumenter = this;
        InstrumentedMethodsCollector methodCollector = new InstrumentedMethodsCollector(this.api, sourceFilesCollector, testDiscoveryInstrumenter, testDiscoveryInstrumenter.myClassName);
        var1_1.accept(methodCollector, 0);
        TestDiscoveryProjectData.getProjectData().addClassMetadata(Collections.singletonList(new ClassMetadata(this.myClassName, var3_3.getSources(), var2_2.getChecksums())));
        return methodCollector.instrumentedMethods();
    }

    /*
     * WARNING - void declaration
     */
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.myMethodFilter.visit(version, access, name, signature, superName, interfaces);
        super.visit((int)var1_1, (int)var2_2, (String)var3_3, signature, superName, interfaces);
    }

    /*
     * WARNING - void declaration
     */
    public MethodVisitor visitMethod(int access2, String name, String desc, String signature, String[] exceptions) {
        void var2_3;
        void var1_2;
        void var3_4;
        MethodVisitor mv = this.cv.visitMethod(access2, name, desc, signature, exceptions);
        if (mv == null) {
            return null;
        }
        if (this.myMethodNames.length == 0) {
            return mv;
        }
        if ("<clinit>".equals(name)) {
            return this.createMethodVisitor(mv, name);
        }
        InstrumentedMethodsFilter.Decision access2 = this.myMethodFilter.shouldVisitMethod(access2, name, (String)var3_4, signature, exceptions, this.myInstrumentConstructors);
        if (access2 != InstrumentedMethodsFilter.Decision.YES) {
            return mv;
        }
        MethodVisitor newMv = new MethodVisitor(this, 589824, mv){
            final int myMethodId;
            final /* synthetic */ TestDiscoveryInstrumenter this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((int)var2_2, (MethodVisitor)var3_3);
                this.myMethodId = this.this$0.myCurrentMethodCount++;
            }

            public void visitCode() {
                this.mv.visitFieldInsn(178, this.this$0.getInternalClassName(), TestDiscoveryInstrumenter.METHODS_VISITED, TestDiscoveryInstrumenter.METHODS_VISITED_CLASS);
                1 v0 = this;
                TestDiscoveryInstrumenter.access$100(v0, v0.myMethodId);
                this.visitInsn(4);
                this.visitInsn(84);
                super.visitCode();
            }
        };
        return this.createMethodVisitor((MethodVisitor)var1_2, (String)var2_3);
    }

    public void visitEnd() {
        if (this.myMethodNames.length > 0) {
            this.generateMembers();
        }
        super.visitEnd();
    }

    /*
     * WARNING - void declaration
     */
    public void initField(MethodVisitor mv) {
        void var1_1;
        mv.visitLdcInsn(this.myClassName);
        TestDiscoveryInstrumenter.pushInstruction(mv, this.myMethodNames.length);
        mv.visitIntInsn(188, 4);
        TestDiscoveryInstrumenter.pushInstruction(mv, this.myMethodNames.length);
        mv.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i < this.myMethodNames.length; ++i) {
            mv.visitInsn(89);
            TestDiscoveryInstrumenter.pushInstruction(mv, i);
            mv.visitLdcInsn(this.myMethodNames[i]);
            mv.visitInsn(83);
        }
        mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/TestDiscoveryProjectData", "trace", "(Ljava/lang/String;[Z[Ljava/lang/String;)[Z", false);
        var1_1.visitFieldInsn(179, this.getInternalClassName(), METHODS_VISITED, METHODS_VISITED_CLASS);
    }

    /*
     * WARNING - void declaration
     */
    private static void pushInstruction(MethodVisitor mv, int operand) {
        void var1_1;
        MethodVisitor methodVisitor;
        if (operand < 127) {
            mv.visitIntInsn(16, operand);
            return;
        }
        methodVisitor.visitIntInsn(17, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(MethodVisitor x0, int x1) {
        void var1_1;
        TestDiscoveryInstrumenter.pushInstruction(x0, (int)var1_1);
    }
}

