/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.transformers.AbstractFirStatusResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.DesignationState;
import org.jetbrains.kotlin.fir.resolve.transformers.StatusComputationSession;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0014J\f\u0010\u000b\u001a\u00020\t*\u00020\nH\u0014J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirDesignatedStatusResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer;", "designation", "Lorg/jetbrains/kotlin/fir/resolve/transformers/DesignationState;", "statusComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/DesignationState;Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;)V", "needResolveMembers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "needResolveNestedClassifiers", "transformClassContent", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "data", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirStatusResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirStatusResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirDesignatedStatusResolveTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n*L\n1#1,510:1\n234#2,4:511\n*S KotlinDebug\n*F\n+ 1 FirStatusResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirDesignatedStatusResolveTransformer\n*L\n103#1:511,4\n*E\n"})
public class FirDesignatedStatusResolveTransformer
extends AbstractFirStatusResolveTransformer {
    @NotNull
    private final DesignationState designation;

    public FirDesignatedStatusResolveTransformer(@NotNull DesignationState designation, @NotNull StatusComputationSession statusComputationSession) {
        Intrinsics.checkNotNullParameter((Object)designation, (String)"designation");
        Intrinsics.checkNotNullParameter((Object)statusComputationSession, (String)"statusComputationSession");
        super(statusComputationSession);
        this.designation = designation;
    }

    @Override
    protected boolean needResolveMembers(@NotNull FirDeclaration $this$needResolveMembers) {
        Intrinsics.checkNotNullParameter((Object)$this$needResolveMembers, (String)"<this>");
        return this.designation.getClassLocated();
    }

    @Override
    protected boolean needResolveNestedClassifiers(@NotNull FirDeclaration $this$needResolveNestedClassifiers) {
        Intrinsics.checkNotNullParameter((Object)$this$needResolveNestedClassifiers, (String)"<this>");
        return !this.designation.getClassLocated();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformClassContent(@NotNull FirClass firClass, @Nullable FirResolvedDeclarationStatus data) {
        Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
        FirSession firSession = this.getSession();
        FirElement element$iv = firClass;
        boolean $i$f$whileAnalysing = false;
        try {
            FirStatement firStatement;
            boolean bl = false;
            if (this.designation.shouldSkipClass(firClass)) {
                return firClass;
            }
            FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)firClass.getSymbol(), FirResolvePhase.TYPES);
            boolean classLocated = this.designation.getClassLocated();
            if (classLocated) {
                boolean bl2 = Intrinsics.areEqual((Object)firClass, (Object)this.designation.getTargetClass());
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                StatusComputationSession.StatusComputationStatus computationStatus = this.getStatusComputationSession().startComputing(firClass);
                this.getStatusComputationSession().forceResolveStatusesOfSupertypes(firClass);
                if (computationStatus != StatusComputationSession.StatusComputationStatus.Computed) {
                    firClass.transformStatus(this, this.getStatusResolver().resolveStatus(firClass, this.getContainingClass(), false));
                }
            } else if (!(firClass.getStatus() instanceof FirResolvedDeclarationStatus)) {
                firClass.transformStatus(this, this.getStatusResolver().resolveStatus(firClass, this.getContainingClass(), false));
                this.getStatusComputationSession().computeOnlyClassStatus(firClass);
            }
            FirStatement it = firStatement = this.transformClass(firClass, data);
            boolean bl3 = false;
            if (classLocated) {
                this.getStatusComputationSession().endComputing(firClass);
            }
            return firStatement;
        }
        catch (Throwable throwable$iv) {
            void session$iv;
            UtilsKt.getExceptionHandler((FirSession)session$iv).handleExceptionOnElementAnalysis(element$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }
}

