/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallCandidateInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaVariableSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u0007\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\b2\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u0007\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\bH\u0007\u001a\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\bH\u0002\u001a\"\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\bH\u0007\u001a\u001a\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\bH\u0007\u001a\u0014\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"isInlinedArgument", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "argument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "allowCrossinline", "getInlineArgumentSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaValueParameterSymbol;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getFunctionSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;", "getDefaultArgumentSymbol", "Lkotlin/Pair;", "getCallExpressionSymbol", "resolveFunctionCall", "Lorg/jetbrains/kotlin/analysis/api/resolution/KaFunctionCall;", "expression", "isArrayGeneratorConstructorCall", "symbol", "kotlin.code-insight.utils"})
@SourceDebugExtension(value={"SMAP\nInlineUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/InlineUtilsKt\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,102:1\n66#2,2:103\n66#2,2:105\n*S KotlinDebug\n*F\n+ 1 InlineUtils.kt\norg/jetbrains/kotlin/idea/codeinsight/utils/InlineUtilsKt\n*L\n50#1:103,2\n53#1:105,2\n*E\n"})
public final class InlineUtilsKt {
    @ApiStatus.Internal
    public static final boolean isInlinedArgument(@NotNull KaSession $this$isInlinedArgument, @NotNull KtFunction argument2, boolean allowCrossinline) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlinedArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        return InlineUtilsKt.getInlineArgumentSymbol($this$isInlinedArgument, (KtExpression)argument2, allowCrossinline) != null;
    }

    public static /* synthetic */ boolean isInlinedArgument$default(KaSession kaSession, KtFunction ktFunction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return InlineUtilsKt.isInlinedArgument(kaSession, ktFunction, bl);
    }

    @ApiStatus.Internal
    @Nullable
    public static final KaValueParameterSymbol getInlineArgumentSymbol(@NotNull KaSession $this$getInlineArgumentSymbol, @NotNull KtExpression argument2, boolean allowCrossinline) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlineArgumentSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        if (!(argument2 instanceof KtFunctionLiteral || argument2 instanceof KtNamedFunction || argument2 instanceof KtCallableReferenceExpression)) {
            return null;
        }
        Pair<KaFunctionSymbol, KaValueParameterSymbol> pair = InlineUtilsKt.getCallExpressionSymbol($this$getInlineArgumentSymbol, argument2);
        if (pair == null && (pair = InlineUtilsKt.getDefaultArgumentSymbol($this$getInlineArgumentSymbol, argument2)) == null) {
            return null;
        }
        Pair<KaFunctionSymbol, KaValueParameterSymbol> pair2 = pair;
        KaFunctionSymbol symbol = (KaFunctionSymbol)pair2.component1();
        KaValueParameterSymbol argumentSymbol = (KaValueParameterSymbol)pair2.component2();
        if (symbol instanceof KaNamedFunctionSymbol && ((KaNamedFunctionSymbol)symbol).isInline() || InlineUtilsKt.isArrayGeneratorConstructorCall($this$getInlineArgumentSymbol, symbol)) {
            if (argumentSymbol.isNoinline()) {
                return null;
            }
            if (!allowCrossinline && argumentSymbol.isCrossinline()) {
                return null;
            }
            KaType parameterType = argumentSymbol.getReturnType();
            if (!$this$getInlineArgumentSymbol.isMarkedNullable(parameterType) && ($this$getInlineArgumentSymbol.isFunctionType(parameterType) || $this$getInlineArgumentSymbol.isSuspendFunctionType(parameterType))) {
                return argumentSymbol;
            }
        }
        return null;
    }

    public static /* synthetic */ KaValueParameterSymbol getInlineArgumentSymbol$default(KaSession kaSession, KtExpression ktExpression, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return InlineUtilsKt.getInlineArgumentSymbol(kaSession, ktExpression, bl);
    }

    @ApiStatus.Internal
    @Nullable
    public static final KaFunctionSymbol getFunctionSymbol(@NotNull KaSession $this$getFunctionSymbol, @NotNull KtExpression argument2) {
        Intrinsics.checkNotNullParameter((Object)$this$getFunctionSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Object object = InlineUtilsKt.getCallExpressionSymbol($this$getFunctionSymbol, argument2);
        if (object == null || (object = (KaFunctionSymbol)object.getFirst()) == null) {
            Pair<KaFunctionSymbol, KaValueParameterSymbol> pair = InlineUtilsKt.getDefaultArgumentSymbol($this$getFunctionSymbol, argument2);
            object = pair != null ? (KaFunctionSymbol)pair.getFirst() : null;
        }
        return object;
    }

    private static final Pair<KaFunctionSymbol, KaValueParameterSymbol> getDefaultArgumentSymbol(KaSession $this$getDefaultArgumentSymbol, KtExpression argument2) {
        if (!(argument2 instanceof KtFunction) && !(argument2 instanceof KtCallableReferenceExpression)) {
            return null;
        }
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)argument2;
        boolean withSelf$iv22 = false;
        boolean $i$f$parentOfType = false;
        KtParameter ktParameter = (KtParameter)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtParameter.class, (boolean)true);
        if (ktParameter == null) {
            return null;
        }
        KtParameter parameter = ktParameter;
        PsiElement withSelf$iv22 = argument2.getParent();
        KtLambdaExpression ktLambdaExpression = withSelf$iv22 instanceof KtLambdaExpression ? (KtLambdaExpression)withSelf$iv22 : null;
        if (ktLambdaExpression == null) {
            return null;
        }
        KtLambdaExpression lambdaExpression = ktLambdaExpression;
        if (!Intrinsics.areEqual((Object)parameter.getDefaultValue(), (Object)lambdaExpression)) {
            return null;
        }
        PsiElement $this$parentOfType_u24default$iv2 = (PsiElement)parameter;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType2 = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, KtNamedFunction.class, (boolean)true);
        if (ktNamedFunction == null) {
            return null;
        }
        KtNamedFunction function = ktNamedFunction;
        KaFunctionSymbol symbol = $this$getDefaultArgumentSymbol.getSymbol(function);
        KaVariableSymbol kaVariableSymbol = $this$getDefaultArgumentSymbol.getSymbol(parameter);
        KaValueParameterSymbol kaValueParameterSymbol = kaVariableSymbol instanceof KaValueParameterSymbol ? (KaValueParameterSymbol)kaVariableSymbol : null;
        if (kaValueParameterSymbol == null) {
            return null;
        }
        KaValueParameterSymbol argumentSymbol = kaValueParameterSymbol;
        return TuplesKt.to((Object)symbol, (Object)argumentSymbol);
    }

    @ApiStatus.Internal
    @Nullable
    public static final Pair<KaFunctionSymbol, KaValueParameterSymbol> getCallExpressionSymbol(@NotNull KaSession $this$getCallExpressionSymbol, @NotNull KtExpression argument2) {
        Intrinsics.checkNotNullParameter((Object)$this$getCallExpressionSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        if (!(argument2 instanceof KtFunction) && !(argument2 instanceof KtCallableReferenceExpression)) {
            return null;
        }
        KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)argument2);
        KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression parentCallExpression = ktCallExpression;
        KaFunctionCall<?> kaFunctionCall = InlineUtilsKt.resolveFunctionCall($this$getCallExpressionSymbol, (KtExpression)parentCallExpression);
        if (kaFunctionCall == null) {
            return null;
        }
        KaFunctionCall<?> parentCall = kaFunctionCall;
        KaFunctionSymbol symbol = (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(parentCall.getPartiallyAppliedSymbol());
        KtValueArgument ktValueArgument = KotlinPsiUtils.getContainingValueArgument(parentCallExpression, argument2);
        if (ktValueArgument == null) {
            return null;
        }
        KtValueArgument valueArgument = ktValueArgument;
        KaLifetimeOwner kaLifetimeOwner = parentCall.getArgumentMapping().get(valueArgument.getArgumentExpression());
        if (kaLifetimeOwner == null || (kaLifetimeOwner = (KaValueParameterSymbol)kaLifetimeOwner.getSymbol()) == null) {
            return null;
        }
        KaLifetimeOwner argumentSymbol = kaLifetimeOwner;
        return TuplesKt.to((Object)symbol, argumentSymbol);
    }

    @ApiStatus.Internal
    @Nullable
    public static final KaFunctionCall<?> resolveFunctionCall(@NotNull KaSession $this$resolveFunctionCall, @NotNull KtExpression expression) {
        KaFunctionCall<?> successfulCall;
        Intrinsics.checkNotNullParameter((Object)$this$resolveFunctionCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KaCallInfo kaCallInfo = $this$resolveFunctionCall.resolveToCall((KtElement)expression);
        KaFunctionCall<Object> kaFunctionCall = successfulCall = kaCallInfo != null ? KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo) : null;
        if (successfulCall != null) {
            return successfulCall;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        KaCallCandidateInfo kaCallCandidateInfo = (KaCallCandidateInfo)CollectionsKt.firstOrNull($this$resolveFunctionCall.resolveToCallCandidates((KtElement)expression));
        KaCall kaCall = kaCallCandidateInfo != null ? kaCallCandidateInfo.getCandidate() : null;
        return kaCall instanceof KaFunctionCall ? (KaFunctionCall)kaCall : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isArrayGeneratorConstructorCall(KaSession $this$isArrayGeneratorConstructorCall, KaFunctionSymbol symbol) {
        if (symbol instanceof KaConstructorSymbol) {
            ClassId classId = ((KaConstructorSymbol)symbol).getContainingClassId();
            if (!Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getArray()) && !StandardClassIds.INSTANCE.getElementTypeByPrimitiveArrayType().containsKey(classId)) {
                if (!StandardClassIds.INSTANCE.getElementTypeByUnsignedArrayType().containsKey(classId)) return false;
            }
            boolean bl = true;
            boolean isArrayClass = bl;
            if (!isArrayClass) return false;
            if (!InlineUtilsKt.isArrayGeneratorConstructorCall$checkParameters($this$isArrayGeneratorConstructorCall, symbol)) return false;
            return true;
        }
        if (!(symbol instanceof KaNamedFunctionSymbol)) return false;
        if (!symbol.isExtension()) return false;
        KaType receiverType = KaCallableSymbolKt.getReceiverType(symbol);
        if (!(receiverType instanceof KaClassType)) return false;
        if (!StandardClassIds.INSTANCE.getElementTypeByUnsignedArrayType().containsKey(((KaClassType)receiverType).getClassId())) return false;
        CallableId callableId = symbol.getCallableId();
        if (!Intrinsics.areEqual((Object)(callableId != null ? callableId.getPackageName() : null), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) return false;
        if (!InlineUtilsKt.isArrayGeneratorConstructorCall$checkParameters($this$isArrayGeneratorConstructorCall, symbol)) return false;
        return true;
    }

    private static final boolean isArrayGeneratorConstructorCall$checkParameters(KaSession $this_isArrayGeneratorConstructorCall, KaFunctionSymbol symbol) {
        return symbol.getValueParameters().size() == 2 && $this_isArrayGeneratorConstructorCall.isIntType(symbol.getValueParameters().get(0).getReturnType()) && $this_isArrayGeneratorConstructorCall.isFunctionType(symbol.getValueParameters().get(1).getReturnType());
    }
}

