/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.ConvertToBlockBodyContext;
import org.jetbrains.kotlin.idea.codeinsight.utils.ConvertToBlockBodyUtils;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0014J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToBlockBodyIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "<init>", "()V", "isApplicableTo", "", "element", "caretOffset", "", "skipProcessingFurtherElementsAfter", "Lcom/intellij/psi/PsiElement;", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "Holder", "kotlin.idea"})
public final class ConvertToBlockBodyIntention
extends SelfTargetingIntention<KtDeclarationWithBody> {
    public ConvertToBlockBodyIntention() {
        super(KtDeclarationWithBody.class, KotlinBundle.lazyMessage((String)"convert.to.block.body", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtDeclarationWithBody element, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Holder.createContext$default(Holder.INSTANCE, element, false, 2, null) != null;
    }

    @Override
    protected boolean skipProcessingFurtherElementsAfter(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof KtDeclaration || super.skipProcessingFurtherElementsAfter(element);
    }

    @Override
    public void applyTo(@NotNull KtDeclarationWithBody element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Holder.INSTANCE.convert(element, true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToBlockBodyIntention$Holder;", "", "<init>", "()V", "convert", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "declaration", "withReformat", "", "createContext", "Lorg/jetbrains/kotlin/idea/codeinsight/utils/ConvertToBlockBodyContext;", "reformat", "returnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin.idea"})
    public static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();

        private Holder() {
        }

        @NotNull
        public final KtDeclarationWithBody convert(@NotNull KtDeclarationWithBody declaration, boolean withReformat) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            ConvertToBlockBodyContext convertToBlockBodyContext = this.createContext(declaration, withReformat);
            if (convertToBlockBodyContext == null) {
                return declaration;
            }
            ConvertToBlockBodyContext context = convertToBlockBodyContext;
            ConvertToBlockBodyUtils.INSTANCE.convert(declaration, context);
            return declaration;
        }

        public static /* synthetic */ KtDeclarationWithBody convert$default(Holder holder2, KtDeclarationWithBody ktDeclarationWithBody, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return holder2.convert(ktDeclarationWithBody, bl);
        }

        @Nullable
        public final ConvertToBlockBodyContext createContext(@NotNull KtDeclarationWithBody declaration, boolean reformat) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (!ConvertToBlockBodyUtils.INSTANCE.isConvertibleByPsi(declaration)) {
                return null;
            }
            KtExpression ktExpression = declaration.getBodyExpression();
            if (ktExpression == null) {
                return null;
            }
            KtExpression body2 = ktExpression;
            KotlinType kotlinType = this.returnType(declaration);
            if (kotlinType == null) {
                return null;
            }
            KotlinType returnType = kotlinType;
            if (KotlinTypeKt.isError((KotlinType)returnType) && declaration instanceof KtNamedFunction && !((KtNamedFunction)declaration).hasDeclaredReturnType()) {
                return null;
            }
            KotlinType bodyType = ResolutionUtils.analyze$default((KtElement)body2, null, 1, null).getType(body2);
            KotlinType kotlinType2 = bodyType;
            KotlinType kotlinType3 = bodyType;
            return new ConvertToBlockBodyContext(TypeUtilsKt.isUnit((KotlinType)returnType), TypeUtilsKt.isNothing((KotlinType)returnType), IdeDescriptorRenderers.SOURCE_CODE.renderType(returnType), kotlinType2 != null ? TypeUtilsKt.isUnit((KotlinType)kotlinType2) : false, kotlinType3 != null ? TypeUtilsKt.isNothing((KotlinType)kotlinType3) : false, reformat, ShortenReferencesFacility.Companion.getInstance());
        }

        public static /* synthetic */ ConvertToBlockBodyContext createContext$default(Holder holder2, KtDeclarationWithBody ktDeclarationWithBody, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return holder2.createContext(ktDeclarationWithBody, bl);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final KotlinType returnType(KtDeclarationWithBody $this$returnType) {
            KtProperty parent2;
            FunctionDescriptor functionDescriptor;
            KtDeclarationWithBody ktDeclarationWithBody = $this$returnType;
            if (ktDeclarationWithBody instanceof KtNamedFunction) {
                FunctionDescriptor descriptor2;
                FunctionDescriptor functionDescriptor3 = descriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default((KtNamedFunction)$this$returnType, null, 1, null);
                functionDescriptor3 = functionDescriptor3;
                if (functionDescriptor2 == null) return null;
                if ((functionDescriptor3 = functionDescriptor3.getReturnType()) == null) {
                    return null;
                }
                FunctionDescriptor returnType = functionDescriptor3;
                if (FlexibleTypesKt.isNullabilityFlexible((KotlinType)returnType)) {
                    Collection collection = descriptor2.getOverriddenDescriptors();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOverriddenDescriptors(...)");
                    FunctionDescriptor functionDescriptor4 = (FunctionDescriptor)CollectionsKt.firstOrNull((Iterable)collection);
                    boolean bl = functionDescriptor4 != null && (functionDescriptor4 = functionDescriptor4.getReturnType()) != null ? !functionDescriptor4.isMarkedNullable() : false;
                    if (bl) {
                        functionDescriptor = TypeUtilsKt.makeNotNullable((KotlinType)returnType);
                        return functionDescriptor;
                    }
                }
                functionDescriptor = returnType;
                return functionDescriptor;
            }
            if (!(ktDeclarationWithBody instanceof KtPropertyAccessor)) {
                return null;
            }
            PsiElement psiElement = ((KtPropertyAccessor)$this$returnType).getParent();
            KtProperty ktProperty = parent2 = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
            VariableDescriptor variableDescriptor = ktProperty != null ? ResolutionUtils.resolveToDescriptorIfAny$default(ktProperty, null, 1, null) : null;
            if (!(variableDescriptor instanceof CallableDescriptor)) return null;
            CallableDescriptor callableDescriptor = (CallableDescriptor)variableDescriptor;
            if (callableDescriptor == null) return null;
            functionDescriptor = callableDescriptor.getReturnType();
            return functionDescriptor;
        }
    }
}

