/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.codeinsight.utils.DemorgansLawUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0016\u0010\r\u001a\u0004\u0018\u00010\u0003*\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0002H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertBinaryExpressionWithDemorgansLawIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "Lorg/jetbrains/kotlin/idea/codeinsight/utils/DemorgansLawUtils$Context;", "<init>", "()V", "getFamilyName", "", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "isApplicableByPsi", "", "invoke", "", "actionContext", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "kotlin.code-insight.intentions.k2"})
public final class ConvertBinaryExpressionWithDemorgansLawIntention
extends KotlinApplicableModCommandAction<KtBinaryExpression, DemorgansLawUtils.Context> {
    public ConvertBinaryExpressionWithDemorgansLawIntention() {
        super(Reflection.getOrCreateKotlinClass(KtBinaryExpression.class));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"demorgan.law", (Object[])new Object[0]);
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull KtBinaryExpression element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IElementType iElementType = DemorgansLawUtils.INSTANCE.topmostBinaryExpression(element).getOperationToken();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.ANDAND)) {
            string = KotlinBundle.message((String)"replace.&&.with.||", (Object[])new Object[0]);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.OROR)) {
            string = KotlinBundle.message((String)"replace.||.with.&&", (Object[])new Object[0]);
        } else {
            throw new IllegalArgumentException();
        }
        String actionName = string;
        Presentation presentation = Presentation.of((String)actionName);
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
        return presentation;
    }

    @Override
    @Nullable
    public DemorgansLawUtils.Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List<KtExpression> list2 = DemorgansLawUtils.INSTANCE.getOperandsIfAllBoolean(element);
        if (list2 == null) {
            return null;
        }
        List<KtExpression> operands = list2;
        return DemorgansLawUtils.INSTANCE.prepareContext(operands);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtBinaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtBinaryExpression topmostBinaryExpression = DemorgansLawUtils.INSTANCE.topmostBinaryExpression(element);
        IElementType iElementType = topmostBinaryExpression.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
        IElementType operationToken = iElementType;
        if (!Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.ANDAND) && !Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.OROR)) {
            return false;
        }
        return DemorgansLawUtils.INSTANCE.splitBooleanSequence(topmostBinaryExpression) != null;
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtBinaryExpression element, @NotNull DemorgansLawUtils.Context elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        KtBinaryExpression topmostBinaryExpression = DemorgansLawUtils.INSTANCE.topmostBinaryExpression(element);
        if (DemorgansLawUtils.INSTANCE.splitBooleanSequence(topmostBinaryExpression) == null) {
            return;
        }
        DemorgansLawUtils.INSTANCE.applyDemorgansLaw(topmostBinaryExpression, elementContext);
    }
}

