/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectChangesBuilder;
import org.jetbrains.idea.maven.project.MavenProjectsManagerEx;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenProjectsTreeUpdateResult;
import org.jetbrains.idea.maven.utils.ParallelRunner;

@ApiStatus.Internal
class MavenProjectsTreeUpdateContext {
    private final MavenProjectsTree myTree;
    private final Map<MavenProject, MavenProjectChanges> updatedProjectsWithChanges = new ConcurrentHashMap<MavenProject, MavenProjectChanges>();
    private final Set<MavenProject> deletedProjects = ConcurrentHashMap.newKeySet();

    public MavenProjectsTreeUpdateContext(MavenProjectsTree tree) {
        this.myTree = tree;
    }

    public void updated(MavenProject project, @NotNull MavenProjectChanges changes) {
        if (changes == null) {
            MavenProjectsTreeUpdateContext.$$$reportNull$$$0(0);
        }
        this.deletedProjects.remove(project);
        this.updatedProjectsWithChanges.compute(project, (__, previousChanges) -> previousChanges == null ? changes : MavenProjectChangesBuilder.merged(changes, previousChanges));
    }

    public void deleted(MavenProject project) {
        this.updatedProjectsWithChanges.remove(project);
        this.deletedProjects.add(project);
    }

    public MavenProjectsTreeUpdateResult toUpdateResult() {
        return new MavenProjectsTreeUpdateResult(this.mapToListWithPairs(), new ArrayList<MavenProject>(this.deletedProjects));
    }

    public void fireUpdatedIfNecessary() {
        if (this.updatedProjectsWithChanges.isEmpty() && this.deletedProjects.isEmpty()) {
            return;
        }
        List<Pair<MavenProject, MavenProjectChanges>> updated = this.mapToListWithPairs();
        ArrayList<MavenProject> deleted = new ArrayList<MavenProject>(this.deletedProjects);
        this.myTree.fireProjectsUpdated(updated, deleted);
    }

    @NotNull
    private List<Pair<MavenProject, MavenProjectChanges>> mapToListWithPairs() {
        ConcurrentHashMap existingFiles = new ConcurrentHashMap();
        Predicate<File> fileExistsPredicate = f -> existingFiles.computeIfAbsent(f, file2 -> MavenProjectsManagerEx.getInstance(this.myTree.getProject()).projectFileExists((File)file2));
        ParallelRunner.getInstance(this.myTree.getProject()).runInParallelBlocking(this.updatedProjectsWithChanges.keySet(), mavenProject -> {
            mavenProject.collectProblems(fileExistsPredicate);
            return null;
        });
        ArrayList<Pair<MavenProject, MavenProjectChanges>> result2 = new ArrayList<Pair<MavenProject, MavenProjectChanges>>(this.updatedProjectsWithChanges.size());
        for (Map.Entry<MavenProject, MavenProjectChanges> entry : this.updatedProjectsWithChanges.entrySet()) {
            result2.add((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)entry.getKey(), (Object)entry.getValue()));
        }
        ArrayList<Pair<MavenProject, MavenProjectChanges>> arrayList = result2;
        if (arrayList == null) {
            MavenProjectsTreeUpdateContext.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public Collection<MavenProject> getDeletedProjects() {
        return this.deletedProjects;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProjectsTreeUpdateContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsTreeUpdateContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToListWithPairs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updated";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

