/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BidirectionalMap<K, V>
implements Map<K, V> {
    private final Map<K, V> myKeyToValueMap = new HashMap();
    private final Map<V, List<K>> myValueToKeysMap = new HashMap<V, List<K>>();

    @Override
    public V put(K key, V value2) {
        V oldValue = this.myKeyToValueMap.put(key, value2);
        if (oldValue != null) {
            if (oldValue.equals(value2)) {
                return oldValue;
            }
            List<K> array = this.myValueToKeysMap.get(oldValue);
            array.remove(key);
            if (array.isEmpty()) {
                this.myValueToKeysMap.remove(oldValue);
            }
        }
        this.myValueToKeysMap.computeIfAbsent((List)value2, (Function<List, List<Object>>)((Function<Object, List>)__ -> new SmartList())).add(key);
        return oldValue;
    }

    @Override
    public void clear() {
        this.myKeyToValueMap.clear();
        this.myValueToKeysMap.clear();
    }

    @Nullable
    public List<K> getKeysByValue(V value2) {
        return this.myValueToKeysMap.get(value2);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.myKeyToValueMap.keySet();
        if (set == null) {
            BidirectionalMap.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    public int size() {
        return this.myKeyToValueMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myKeyToValueMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.myKeyToValueMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.myValueToKeysMap.containsKey(value2);
    }

    @Override
    public V get(Object key) {
        return this.myKeyToValueMap.get(key);
    }

    @Override
    public V remove(Object key) {
        V value2 = this.myKeyToValueMap.remove(key);
        List<K> ks = this.myValueToKeysMap.get(value2);
        if (ks != null) {
            if (ks.size() > 1) {
                ks.remove(key);
            } else {
                this.myValueToKeysMap.remove(value2);
            }
        }
        return value2;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            BidirectionalMap.$$$reportNull$$$0(1);
        }
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        Set<V> set = this.myValueToKeysMap.keySet();
        if (set == null) {
            BidirectionalMap.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.myKeyToValueMap.entrySet();
        if (set == null) {
            BidirectionalMap.$$$reportNull$$$0(3);
        }
        return set;
    }

    public String toString() {
        return this.myKeyToValueMap.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/BidirectionalMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/BidirectionalMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

