/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.lazy.types;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.load.java.lazy.types.JavaTypeAttributes;
import org.jetbrains.kotlin.load.java.lazy.types.JavaTypeFlexibility;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErasureProjectionComputer;
import org.jetbrains.kotlin.types.ErasureTypeAttributes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeParameterUpperBoundEraser;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/load/java/lazy/types/RawProjectionComputer;", "Lorg/jetbrains/kotlin/types/ErasureProjectionComputer;", "<init>", "()V", "computeProjection", "Lorg/jetbrains/kotlin/types/TypeProjection;", "parameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "typeAttr", "Lorg/jetbrains/kotlin/types/ErasureTypeAttributes;", "typeParameterUpperBoundEraser", "Lorg/jetbrains/kotlin/types/TypeParameterUpperBoundEraser;", "erasedUpperBound", "Lorg/jetbrains/kotlin/types/KotlinType;", "descriptors.jvm"})
public final class RawProjectionComputer
extends ErasureProjectionComputer {
    @Override
    @NotNull
    public TypeProjection computeProjection(@NotNull TypeParameterDescriptor parameter, @NotNull ErasureTypeAttributes typeAttr, @NotNull TypeParameterUpperBoundEraser typeParameterUpperBoundEraser, @NotNull KotlinType erasedUpperBound) {
        TypeProjection typeProjection;
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(typeAttr, "typeAttr");
        Intrinsics.checkNotNullParameter(typeParameterUpperBoundEraser, "typeParameterUpperBoundEraser");
        Intrinsics.checkNotNullParameter(erasedUpperBound, "erasedUpperBound");
        if (!(typeAttr instanceof JavaTypeAttributes)) {
            return super.computeProjection(parameter, typeAttr, typeParameterUpperBoundEraser, erasedUpperBound);
        }
        JavaTypeAttributes newTypeAttr = ((JavaTypeAttributes)typeAttr).isRaw() ? (JavaTypeAttributes)typeAttr : ((JavaTypeAttributes)typeAttr).withFlexibility(JavaTypeFlexibility.INFLEXIBLE);
        switch (WhenMappings.$EnumSwitchMapping$0[newTypeAttr.getFlexibility().ordinal()]) {
            case 1: {
                typeProjection = new TypeProjectionImpl(Variance.INVARIANT, erasedUpperBound);
                break;
            }
            case 2: 
            case 3: {
                if (!parameter.getVariance().getAllowsOutPosition()) {
                    typeProjection = new TypeProjectionImpl(Variance.INVARIANT, DescriptorUtilsKt.getBuiltIns(parameter).getNothingType());
                    break;
                }
                List<TypeParameterDescriptor> list = erasedUpperBound.getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
                if (!((Collection)list).isEmpty()) {
                    typeProjection = new TypeProjectionImpl(Variance.OUT_VARIANCE, erasedUpperBound);
                    break;
                }
                TypeProjection typeProjection2 = TypeUtils.makeStarProjection(parameter, newTypeAttr);
                Intrinsics.checkNotNull(typeProjection2);
                typeProjection = typeProjection2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeProjection;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JavaTypeFlexibility.values().length];
            try {
                nArray[JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaTypeFlexibility.FLEXIBLE_UPPER_BOUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaTypeFlexibility.INFLEXIBLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

