/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.foundation.pager.MeasuredPage;
import androidx.compose.foundation.pager.PagerLayoutInfo;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.layout.AlignmentLine;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.RulerScope;
import androidx.compose.ui.unit.IntSize;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u00c1\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0007\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0007\u0012\u0006\u0010\u0016\u001a\u00020\u000f\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u0002\u0012\u0006\u0010\u001a\u001a\u00020\u000f\u0012\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010D\u001a\u0004\u0018\u00010\u00002\u0006\u0010E\u001a\u00020\u0007J\t\u0010F\u001a\u00020GH\u0096\u0001R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010$R\u0014\u0010\t\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010\f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010$R\u0014\u0010\r\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010$R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010\u0010\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010$R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010/R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u0015\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010$R\u0011\u0010\u0016\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010,R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u000e\u0010\u0019\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010,R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\"R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\"R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020=8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010$R\u0011\u0010B\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010,R\u001e\u0010H\u001a\u000e\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020\u00070IX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u0012\u0010M\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bN\u0010$R'\u0010O\u001a\u0015\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020G\u0018\u00010P\u00a2\u0006\u0002\bR8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR\u0012\u0010U\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bV\u0010$\u00a8\u0006W"}, d2={"Landroidx/compose/foundation/pager/PagerMeasureResult;", "Landroidx/compose/foundation/pager/PagerLayoutInfo;", "Landroidx/compose/ui/layout/MeasureResult;", "visiblePagesInfo", "", "Landroidx/compose/foundation/pager/MeasuredPage;", "pageSize", "", "pageSpacing", "afterContentPadding", "orientation", "Landroidx/compose/foundation/gestures/Orientation;", "viewportStartOffset", "viewportEndOffset", "reverseLayout", "", "beyondViewportPageCount", "firstVisiblePage", "currentPage", "currentPageOffsetFraction", "", "firstVisiblePageScrollOffset", "canScrollForward", "snapPosition", "Landroidx/compose/foundation/gestures/snapping/SnapPosition;", "measureResult", "remeasureNeeded", "extraPagesBefore", "extraPagesAfter", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Ljava/util/List;IIILandroidx/compose/foundation/gestures/Orientation;IIZILandroidx/compose/foundation/pager/MeasuredPage;Landroidx/compose/foundation/pager/MeasuredPage;FIZLandroidx/compose/foundation/gestures/snapping/SnapPosition;Landroidx/compose/ui/layout/MeasureResult;ZLjava/util/List;Ljava/util/List;Lkotlinx/coroutines/CoroutineScope;)V", "getVisiblePagesInfo", "()Ljava/util/List;", "getPageSize", "()I", "getPageSpacing", "getAfterContentPadding", "getOrientation", "()Landroidx/compose/foundation/gestures/Orientation;", "getViewportStartOffset", "getViewportEndOffset", "getReverseLayout", "()Z", "getBeyondViewportPageCount", "getFirstVisiblePage", "()Landroidx/compose/foundation/pager/MeasuredPage;", "getCurrentPage", "getCurrentPageOffsetFraction", "()F", "getFirstVisiblePageScrollOffset", "getCanScrollForward", "getSnapPosition", "()Landroidx/compose/foundation/gestures/snapping/SnapPosition;", "getRemeasureNeeded", "getExtraPagesBefore", "getExtraPagesAfter", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "viewportSize", "Landroidx/compose/ui/unit/IntSize;", "getViewportSize-YbymL2g", "()J", "beforeContentPadding", "getBeforeContentPadding", "canScrollBackward", "getCanScrollBackward", "copyWithScrollDeltaWithoutRemeasure", "delta", "placeChildren", "", "alignmentLines", "", "Landroidx/compose/ui/layout/AlignmentLine;", "getAlignmentLines", "()Ljava/util/Map;", "height", "getHeight", "rulers", "Lkotlin/Function1;", "Landroidx/compose/ui/layout/RulerScope;", "Lkotlin/ExtensionFunctionType;", "getRulers", "()Lkotlin/jvm/functions/Function1;", "width", "getWidth", "foundation"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPagerMeasureResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerMeasureResult.kt\nandroidx/compose/foundation/pager/PagerMeasureResult\n+ 2 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,148:1\n30#2:149\n80#3:150\n35#4,5:151\n35#4,5:156\n35#4,5:161\n*S KotlinDebug\n*F\n+ 1 PagerMeasureResult.kt\nandroidx/compose/foundation/pager/PagerMeasureResult\n*L\n50#1:149\n50#1:150\n115#1:151,5\n116#1:156,5\n117#1:161,5\n*E\n"})
public final class PagerMeasureResult
implements PagerLayoutInfo,
MeasureResult {
    @NotNull
    private final List<MeasuredPage> visiblePagesInfo;
    private final int pageSize;
    private final int pageSpacing;
    private final int afterContentPadding;
    @NotNull
    private final Orientation orientation;
    private final int viewportStartOffset;
    private final int viewportEndOffset;
    private final boolean reverseLayout;
    private final int beyondViewportPageCount;
    @Nullable
    private final MeasuredPage firstVisiblePage;
    @Nullable
    private final MeasuredPage currentPage;
    private final float currentPageOffsetFraction;
    private final int firstVisiblePageScrollOffset;
    private final boolean canScrollForward;
    @NotNull
    private final SnapPosition snapPosition;
    @NotNull
    private final MeasureResult measureResult;
    private final boolean remeasureNeeded;
    @NotNull
    private final List<MeasuredPage> extraPagesBefore;
    @NotNull
    private final List<MeasuredPage> extraPagesAfter;
    @NotNull
    private final CoroutineScope coroutineScope;
    public static final int $stable = 8;

    public PagerMeasureResult(@NotNull List<MeasuredPage> visiblePagesInfo, int pageSize, int pageSpacing, int afterContentPadding, @NotNull Orientation orientation, int viewportStartOffset, int viewportEndOffset, boolean reverseLayout, int beyondViewportPageCount, @Nullable MeasuredPage firstVisiblePage, @Nullable MeasuredPage currentPage, float currentPageOffsetFraction, int firstVisiblePageScrollOffset, boolean canScrollForward, @NotNull SnapPosition snapPosition, @NotNull MeasureResult measureResult, boolean remeasureNeeded, @NotNull List<MeasuredPage> extraPagesBefore, @NotNull List<MeasuredPage> extraPagesAfter, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter(visiblePagesInfo, (String)"visiblePagesInfo");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)snapPosition, (String)"snapPosition");
        Intrinsics.checkNotNullParameter((Object)measureResult, (String)"measureResult");
        Intrinsics.checkNotNullParameter(extraPagesBefore, (String)"extraPagesBefore");
        Intrinsics.checkNotNullParameter(extraPagesAfter, (String)"extraPagesAfter");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.visiblePagesInfo = visiblePagesInfo;
        this.pageSize = pageSize;
        this.pageSpacing = pageSpacing;
        this.afterContentPadding = afterContentPadding;
        this.orientation = orientation;
        this.viewportStartOffset = viewportStartOffset;
        this.viewportEndOffset = viewportEndOffset;
        this.reverseLayout = reverseLayout;
        this.beyondViewportPageCount = beyondViewportPageCount;
        this.firstVisiblePage = firstVisiblePage;
        this.currentPage = currentPage;
        this.currentPageOffsetFraction = currentPageOffsetFraction;
        this.firstVisiblePageScrollOffset = firstVisiblePageScrollOffset;
        this.canScrollForward = canScrollForward;
        this.snapPosition = snapPosition;
        this.measureResult = measureResult;
        this.remeasureNeeded = remeasureNeeded;
        this.extraPagesBefore = extraPagesBefore;
        this.extraPagesAfter = extraPagesAfter;
        this.coroutineScope = coroutineScope;
    }

    public /* synthetic */ PagerMeasureResult(List list2, int n, int n2, int n3, Orientation orientation, int n4, int n5, boolean bl, int n6, MeasuredPage measuredPage, MeasuredPage measuredPage2, float f, int n7, boolean bl2, SnapPosition snapPosition, MeasureResult measureResult, boolean bl3, List list3, List list4, CoroutineScope coroutineScope, int n8, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n8 & 0x20000) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n8 & 0x40000) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        this(list2, n, n2, n3, orientation, n4, n5, bl, n6, measuredPage, measuredPage2, f, n7, bl2, snapPosition, measureResult, bl3, list3, list4, coroutineScope);
    }

    @NotNull
    public List<MeasuredPage> getVisiblePagesInfo() {
        return this.visiblePagesInfo;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getPageSpacing() {
        return this.pageSpacing;
    }

    @Override
    public int getAfterContentPadding() {
        return this.afterContentPadding;
    }

    @Override
    @NotNull
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public int getViewportStartOffset() {
        return this.viewportStartOffset;
    }

    @Override
    public int getViewportEndOffset() {
        return this.viewportEndOffset;
    }

    @Override
    public boolean getReverseLayout() {
        return this.reverseLayout;
    }

    @Override
    public int getBeyondViewportPageCount() {
        return this.beyondViewportPageCount;
    }

    @Nullable
    public final MeasuredPage getFirstVisiblePage() {
        return this.firstVisiblePage;
    }

    @Nullable
    public final MeasuredPage getCurrentPage() {
        return this.currentPage;
    }

    public final float getCurrentPageOffsetFraction() {
        return this.currentPageOffsetFraction;
    }

    public final int getFirstVisiblePageScrollOffset() {
        return this.firstVisiblePageScrollOffset;
    }

    public final boolean getCanScrollForward() {
        return this.canScrollForward;
    }

    @Override
    @NotNull
    public SnapPosition getSnapPosition() {
        return this.snapPosition;
    }

    public final boolean getRemeasureNeeded() {
        return this.remeasureNeeded;
    }

    @NotNull
    public final List<MeasuredPage> getExtraPagesBefore() {
        return this.extraPagesBefore;
    }

    @NotNull
    public final List<MeasuredPage> getExtraPagesAfter() {
        return this.extraPagesAfter;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getViewportSize-YbymL2g() {
        void width$iv;
        int n = this.getWidth();
        int height$iv = this.getHeight();
        boolean $i$f$IntSize = false;
        boolean $i$f$packInts = false;
        return IntSize.constructor-impl((long)width$iv << 32 | (long)height$iv & 0xFFFFFFFFL);
    }

    @Override
    public int getBeforeContentPadding() {
        return -this.getViewportStartOffset();
    }

    public final boolean getCanScrollBackward() {
        MeasuredPage measuredPage = this.firstVisiblePage;
        return (measuredPage != null ? measuredPage.getIndex() : 0) != 0 || this.firstVisiblePageScrollOffset != 0;
    }

    @Nullable
    public final PagerMeasureResult copyWithScrollDeltaWithoutRemeasure(int delta) {
        PagerMeasureResult pagerMeasureResult;
        boolean canApply;
        int deltaToLastItemChange;
        int deltaToFirstItemChange;
        int pageSizeWithSpacing;
        block10: {
            block9: {
                pageSizeWithSpacing = this.getPageSize() + this.getPageSpacing();
                if (this.remeasureNeeded || this.getVisiblePagesInfo().isEmpty() || this.firstVisiblePage == null) break block9;
                int n = this.firstVisiblePageScrollOffset - delta;
                if (0 <= n ? n < pageSizeWithSpacing : false) break block10;
            }
            return null;
        }
        float deltaFraction = pageSizeWithSpacing != 0 ? (float)delta / (float)pageSizeWithSpacing : 0.0f;
        float newCurrentPageOffsetFraction = this.currentPageOffsetFraction - deltaFraction;
        if (this.currentPage == null || newCurrentPageOffsetFraction >= 0.5f || newCurrentPageOffsetFraction <= -0.5f) {
            return null;
        }
        MeasuredPage first = (MeasuredPage)CollectionsKt.first(this.getVisiblePagesInfo());
        MeasuredPage last = (MeasuredPage)CollectionsKt.last(this.getVisiblePagesInfo());
        boolean bl = delta < 0 ? Math.min(deltaToFirstItemChange = first.getOffset() + pageSizeWithSpacing - this.getViewportStartOffset(), deltaToLastItemChange = last.getOffset() + pageSizeWithSpacing - this.getViewportEndOffset()) > -delta : (canApply = Math.min(deltaToFirstItemChange = this.getViewportStartOffset() - first.getOffset(), deltaToLastItemChange = this.getViewportEndOffset() - last.getOffset()) > delta);
        if (canApply) {
            MeasuredPage it;
            MeasuredPage item$iv;
            int index$iv;
            List<MeasuredPage> $this$fastForEach$iv = this.getVisiblePagesInfo();
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (index$iv = 0; index$iv < n; ++index$iv) {
                it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl2 = false;
                it.applyScrollDelta(delta);
            }
            $this$fastForEach$iv = this.extraPagesBefore;
            $i$f$fastForEach = false;
            n = ((Collection)$this$fastForEach$iv).size();
            for (index$iv = 0; index$iv < n; ++index$iv) {
                it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl3 = false;
                it.applyScrollDelta(delta);
            }
            $this$fastForEach$iv = this.extraPagesAfter;
            $i$f$fastForEach = false;
            n = ((Collection)$this$fastForEach$iv).size();
            for (index$iv = 0; index$iv < n; ++index$iv) {
                it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl4 = false;
                it.applyScrollDelta(delta);
            }
            pagerMeasureResult = new PagerMeasureResult(this.getVisiblePagesInfo(), this.getPageSize(), this.getPageSpacing(), this.getAfterContentPadding(), this.getOrientation(), this.getViewportStartOffset(), this.getViewportEndOffset(), this.getReverseLayout(), this.getBeyondViewportPageCount(), this.firstVisiblePage, this.currentPage, this.currentPageOffsetFraction - deltaFraction, this.firstVisiblePageScrollOffset - delta, this.canScrollForward || delta > 0, this.getSnapPosition(), this.measureResult, this.remeasureNeeded, this.extraPagesBefore, this.extraPagesAfter, this.coroutineScope);
        } else {
            pagerMeasureResult = null;
        }
        return pagerMeasureResult;
    }

    @Override
    public void placeChildren() {
        this.measureResult.placeChildren();
    }

    @Override
    public int getWidth() {
        return this.measureResult.getWidth();
    }

    @Override
    public int getHeight() {
        return this.measureResult.getHeight();
    }

    @Override
    @NotNull
    public Map<AlignmentLine, Integer> getAlignmentLines() {
        return this.measureResult.getAlignmentLines();
    }

    @Override
    @Nullable
    public Function1<RulerScope, Unit> getRulers() {
        return this.measureResult.getRulers();
    }
}

