/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.io.importexport.GpxLikeImporter;
import org.openstreetmap.josm.io.nmea.NmeaReader;
import org.openstreetmap.josm.tools.I18n;

public class NMEAImporter
extends GpxLikeImporter<NmeaReader> {
    public static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions("nmea,nme,nma,log,txt", "nmea", I18n.tr("NMEA-0183 Files", new Object[0]), false);

    public NMEAImporter() {
        super(FILE_FILTER, NmeaReader.class);
    }

    @Override
    protected void appendInfoboxContent(StringBuilder msg, boolean success, NmeaReader r) {
        msg.append(I18n.tr("Malformed sentences: {0}", r.getParserMalformed())).append("<br>").append(I18n.tr("Checksum errors: {0}", r.getParserChecksumErrors())).append("<br>");
        if (!success) {
            msg.append(I18n.tr("Unknown sentences: {0}", r.getParserUnknown())).append("<br>");
        }
        msg.append(I18n.tr("Zero coordinates: {0}", r.getParserZeroCoordinates()));
    }

    public static GpxImporter.GpxImporterData loadLayers(InputStream is, File associatedFile, String gpxLayerName) throws IOException {
        NmeaReader r = NMEAImporter.buildAndParse(is, NmeaReader.class);
        boolean parsedProperly = r.getNumberOfCoordinates() > 0;
        r.getGpxData().storageFile = associatedFile;
        return GpxImporter.loadLayers(r.getGpxData(), parsedProperly, gpxLayerName);
    }
}

