/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints.request;

import jakarta.ws.rs.core.Response;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.OIDCLoginProtocol;
import org.keycloak.protocol.oidc.OIDCProviderConfig;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.services.ErrorResponseException;

public abstract class AuthzEndpointRequestParser {
    private static final Logger logger = Logger.getLogger(AuthzEndpointRequestParser.class);
    protected final OIDCProviderConfig config;
    protected final int additionalReqParamsMaxNumber;
    protected final int additionalReqParamsMaxSize;
    protected final boolean additionalReqParamsFailFast;
    protected final int additionalReqParamsMaxOverallSize;
    public static final String AUTHZ_REQUEST_OBJECT = "ParsedRequestObject";
    public static final String AUTHZ_REQUEST_OBJECT_ENCRYPTED = "EncryptedRequestObject";
    public static final Set<String> KNOWN_REQ_PARAMS = new HashSet<String>();

    protected AuthzEndpointRequestParser(KeycloakSession keycloakSession) {
        OIDCLoginProtocol loginProtocol = (OIDCLoginProtocol)keycloakSession.getProvider(LoginProtocol.class, "openid-connect");
        this.config = loginProtocol.getConfig();
        this.additionalReqParamsMaxNumber = this.config.getAdditionalReqParamsMaxNumber();
        this.additionalReqParamsMaxSize = this.config.getAdditionalReqParamsMaxSize();
        this.additionalReqParamsFailFast = this.config.isAdditionalReqParamsFailFast();
        this.additionalReqParamsMaxOverallSize = this.config.getAdditionalReqParamsMaxOverallSize();
    }

    public void parseRequest(AuthorizationEndpointRequest request) {
        String clientId = this.getAndValidateParameter("client_id");
        if (clientId != null && request.clientId != null && !request.clientId.equals(clientId)) {
            throw new IllegalArgumentException("The client_id parameter doesn't match the one from OIDC 'request' or 'request_uri'");
        }
        if (clientId != null) {
            request.clientId = clientId;
        }
        String responseType = this.getAndValidateParameter("response_type");
        this.validateResponseTypeParameter(responseType, request);
        if (responseType != null) {
            request.responseType = responseType;
        }
        request.responseMode = this.replaceIfNotNull(request.responseMode, this.getAndValidateParameter("response_mode"));
        request.redirectUriParam = this.replaceIfNotNull(request.redirectUriParam, this.getAndValidateParameter("redirect_uri"));
        request.state = this.replaceIfNotNull(request.state, this.getAndValidateParameter("state"));
        request.scope = this.replaceIfNotNull(request.scope, this.getAndValidateParameter("scope"));
        request.loginHint = this.replaceIfNotNull(request.loginHint, this.getAndValidateParameter("login_hint"));
        request.prompt = this.replaceIfNotNull(request.prompt, this.getAndValidateParameter("prompt"));
        request.idpHint = this.replaceIfNotNull(request.idpHint, this.getAndValidateParameter("kc_idp_hint"));
        request.action = this.replaceIfNotNull(request.action, this.getAndValidateParameter("kc_action"));
        request.nonce = this.replaceIfNotNull(request.nonce, this.getAndValidateParameter("nonce"));
        request.maxAge = this.replaceIfNotNull(request.maxAge, this.getIntParameter("max_age"));
        request.claims = this.replaceIfNotNull(request.claims, this.getAndValidateParameter("claims"));
        request.acr = this.replaceIfNotNull(request.acr, this.getAndValidateParameter("acr_values"));
        request.display = this.replaceIfNotNull(request.display, this.getAndValidateParameter("display"));
        request.uiLocales = this.replaceIfNotNull(request.uiLocales, this.getAndValidateParameter("ui_locales"));
        request.codeChallenge = this.replaceIfNotNull(request.codeChallenge, this.getAndValidateParameter("code_challenge"));
        request.codeChallengeMethod = this.replaceIfNotNull(request.codeChallengeMethod, this.getAndValidateParameter("code_challenge_method"));
        request.dpopJkt = this.replaceIfNotNull(request.dpopJkt, this.getAndValidateParameter("dpop_jkt"));
        this.extractAdditionalReqParams(request.additionalReqParams);
    }

    protected void validateResponseTypeParameter(String responseTypeParameter, AuthorizationEndpointRequest request) {
        if (responseTypeParameter != null && request.responseType != null && !request.responseType.equals(responseTypeParameter)) {
            logger.warnf("The response_type parameter doesn't match the one from OIDC 'request' or 'request_uri'", new Object[0]);
            request.setInvalidRequestMessage("Parameter response_type does not match");
        }
    }

    protected void extractAdditionalReqParams(Map<String, String> additionalReqParams) {
        int currentAdditionalReqParamMaxOverallSize = 0;
        for (String paramName : this.keySet()) {
            if (KNOWN_REQ_PARAMS.contains(paramName)) {
                logger.debugv("The additional OIDC param ''{0}'' is well known. Continue with the other additional parameters.", (Object)paramName);
                continue;
            }
            String value = this.getParameter(paramName);
            if (value == null || value.trim().isEmpty()) {
                logger.debugv("The additional OIDC param ''{0}'' ignored because it's value is null or blank.", (Object)paramName);
                continue;
            }
            if (additionalReqParams.size() >= this.additionalReqParamsMaxNumber) {
                if (this.additionalReqParamsFailFast) {
                    logger.debugv("The maximum number of allowed parameters ({0}) is exceeded.", (Object)this.additionalReqParamsMaxNumber);
                    throw new ErrorResponseException("invalid_request", "The maximum number of allowed parameters (" + this.additionalReqParamsMaxNumber + ") is exceeded.", Response.Status.BAD_REQUEST);
                }
                logger.debugv("The maximum number of allowed parameters ({0}) is exceeded.", (Object)this.additionalReqParamsMaxNumber);
                break;
            }
            if (value.length() + currentAdditionalReqParamMaxOverallSize > this.additionalReqParamsMaxOverallSize) {
                if (this.additionalReqParamsFailFast) {
                    logger.debugv("The OIDC additional parameter '{0}''s size ({1}) exceeds the maximum allowed size of all parameters ({2}).", (Object)paramName, (Object)value.length(), (Object)this.additionalReqParamsMaxOverallSize);
                    throw new ErrorResponseException("invalid_request", "The OIDC additional parameter '" + paramName + "'s size (" + value.length() + ") exceeds the maximum allowed size of all parameters (" + this.additionalReqParamsMaxOverallSize + ").", Response.Status.BAD_REQUEST);
                }
                logger.debugv("The OIDC additional parameter '{0}''s size exceeds ({1}) the maximum allowed size of all parameters ({2}).", (Object)paramName, (Object)value.length(), (Object)this.additionalReqParamsMaxOverallSize);
                break;
            }
            if (value.length() > this.additionalReqParamsMaxSize) {
                if (this.additionalReqParamsFailFast) {
                    logger.debugv("The OIDC additional parameter '{0}''s size is longer ({1}) than allowed ({2}).", (Object)paramName, (Object)value.length(), (Object)this.additionalReqParamsMaxSize);
                    throw new ErrorResponseException("invalid_request", "The OIDC additional parameter '" + paramName + "'s size is longer (" + value.length() + ") than allowed (" + this.additionalReqParamsMaxSize + ").", Response.Status.BAD_REQUEST);
                }
                logger.debugv("The OIDC additional parameter '{0}''s size is longer ({1}) than allowed ({2}).", (Object)paramName, (Object)value.length(), (Object)this.additionalReqParamsMaxSize);
                break;
            }
            logger.debugv("Adding OIDC additional parameter ''{0}'' as additional parameter.", (Object)paramName);
            currentAdditionalReqParamMaxOverallSize += value.length();
            additionalReqParams.put(paramName, value);
        }
    }

    protected <T> T replaceIfNotNull(T previousVal, T newVal) {
        return newVal == null ? previousVal : newVal;
    }

    protected String getAndValidateParameter(String paramName) {
        String paramValue = this.getParameter(paramName);
        if (paramValue != null) {
            int maxLength = this.config.getMaxLengthForTheParameter(paramName);
            if (paramValue.length() > maxLength) {
                logger.warnf("The size of OIDC parameter '%s' size is longer (%d) than allowed (%d). %s", new Object[]{paramName, paramValue.length(), maxLength, this.additionalReqParamsFailFast ? "Request not allowed." : "Ignoring the parameter."});
                if (this.additionalReqParamsFailFast) {
                    throw new ErrorResponseException("invalid_request", "The size of OIDC parameter '" + paramName + "' is longer than allowed.", Response.Status.BAD_REQUEST);
                }
                return null;
            }
        }
        return paramValue;
    }

    protected abstract String getParameter(String var1);

    protected abstract Integer getIntParameter(String var1);

    protected abstract Set<String> keySet();

    static {
        KNOWN_REQ_PARAMS.add("client_id");
        KNOWN_REQ_PARAMS.add("response_type");
        KNOWN_REQ_PARAMS.add("response_mode");
        KNOWN_REQ_PARAMS.add("redirect_uri");
        KNOWN_REQ_PARAMS.add("state");
        KNOWN_REQ_PARAMS.add("scope");
        KNOWN_REQ_PARAMS.add("login_hint");
        KNOWN_REQ_PARAMS.add("prompt");
        KNOWN_REQ_PARAMS.add("kc_idp_hint");
        KNOWN_REQ_PARAMS.add("kc_action");
        KNOWN_REQ_PARAMS.add("nonce");
        KNOWN_REQ_PARAMS.add("max_age");
        KNOWN_REQ_PARAMS.add("ui_locales");
        KNOWN_REQ_PARAMS.add("request");
        KNOWN_REQ_PARAMS.add("request_uri");
        KNOWN_REQ_PARAMS.add("claims");
        KNOWN_REQ_PARAMS.add("acr_values");
        KNOWN_REQ_PARAMS.add("code_challenge");
        KNOWN_REQ_PARAMS.add("code_challenge_method");
        KNOWN_REQ_PARAMS.add("dpop_jkt");
        KNOWN_REQ_PARAMS.add("client_assertion_type");
        KNOWN_REQ_PARAMS.add("client_assertion");
        KNOWN_REQ_PARAMS.add("client_secret");
    }
}

